/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.batch;

import com.maxifier.mxcache.impl.caches.batch.ValueStrategy;
import java.lang.reflect.Array;
import java.util.BitSet;

final class ArrayValueStrategy<K, V>
implements ValueStrategy<K, V[], V, BitSet> {
    private static final ArrayValueStrategy INSTANCE = new ArrayValueStrategy();

    private ArrayValueStrategy() {
    }

    public static <K, V> ArrayValueStrategy<K, V> getInstance() {
        return INSTANCE;
    }

    @Override
    public V[] compose(V[] knownValue, V[] calculated, BitSet composition) {
        int i = composition.nextSetBit(0);
        int p = 0;
        while (i >= 0) {
            knownValue[i] = calculated[p];
            i = composition.nextSetBit(i + 1);
            ++p;
        }
        return knownValue;
    }

    @Override
    public V[] createValue(Class<V[]> valueType, int n) {
        return (Object[])Array.newInstance(valueType.getComponentType(), n);
    }

    @Override
    public BitSet createComposer(int n) {
        return new BitSet(n);
    }

    @Override
    public void addUnknown(V[] knownValues, BitSet composer, int i, K k) {
        composer.set(i);
    }

    @Override
    public void addKnown(V[] knownValues, BitSet composer, int i, K k, V v) {
        knownValues[i] = v;
    }

    @Override
    public V get(V[] value, int index, K key) {
        return value[index];
    }

    @Override
    public boolean requiresOrder() {
        return true;
    }
}

