/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.batch;

import com.maxifier.mxcache.impl.caches.batch.ArrayKeyStrategy;
import com.maxifier.mxcache.impl.caches.batch.ArrayValueStrategy;
import com.maxifier.mxcache.impl.caches.batch.BatchObjectObjectStorage;
import com.maxifier.mxcache.impl.caches.batch.CollectionKeyStrategy;
import com.maxifier.mxcache.impl.caches.batch.KeyStrategy;
import com.maxifier.mxcache.impl.caches.batch.ListKeyStrategy;
import com.maxifier.mxcache.impl.caches.batch.ListValueStrategy;
import com.maxifier.mxcache.impl.caches.batch.MapValueStrategy;
import com.maxifier.mxcache.impl.caches.batch.ValueStrategy;
import com.maxifier.mxcache.impl.caches.def.ObjectObjectTroveStorage;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.StorageFactory;
import com.maxifier.mxcache.storage.Storage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class BatchFactory
implements StorageFactory {
    private final CacheDescriptor descriptor;

    public BatchFactory(CacheDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Nonnull
    public Storage createStorage(Object owner) {
        ValueStrategy valueStrategy;
        KeyStrategy keyStrategy;
        ObjectObjectTroveStorage storage = new ObjectObjectTroveStorage();
        Class keyType = this.descriptor.getKeyType();
        Class valueType = this.descriptor.getValueType();
        if (List.class.isAssignableFrom(keyType)) {
            keyStrategy = ListKeyStrategy.getInstance();
        } else if (Collection.class.isAssignableFrom(keyType)) {
            keyStrategy = CollectionKeyStrategy.getInstance();
        } else if (keyType.isArray() && !keyType.getComponentType().isPrimitive()) {
            keyStrategy = ArrayKeyStrategy.getInstance();
        } else {
            throw new UnsupportedOperationException("Unsupported batch cache key type: " + keyType);
        }
        if (List.class.isAssignableFrom(valueType)) {
            valueStrategy = ListValueStrategy.getInstance();
        } else if (Map.class.isAssignableFrom(valueType)) {
            valueStrategy = MapValueStrategy.getInstance();
        } else if (valueType.isArray() && !valueType.getComponentType().isPrimitive()) {
            valueStrategy = ArrayValueStrategy.getInstance();
        } else {
            throw new UnsupportedOperationException("Unsupported batch cache value type: " + keyType);
        }
        if (valueStrategy.requiresOrder() && !keyStrategy.isStableOrder()) {
            throw new UnsupportedOperationException("Incompatible key for batch cache: " + keyType + " and " + valueType);
        }
        return new BatchObjectObjectStorage(storage, keyStrategy, valueStrategy, valueType);
    }

    @Override
    public String getImplementationDetails() {
        return "<Batch cache>";
    }
}

