/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.batch;

import com.maxifier.mxcache.caches.Calculable;
import com.maxifier.mxcache.caches.ObjectObjectCalculatable;
import com.maxifier.mxcache.impl.caches.batch.KeyStrategy;
import com.maxifier.mxcache.impl.caches.batch.ValueStrategy;
import com.maxifier.mxcache.storage.CalculableInterceptor;
import com.maxifier.mxcache.storage.ObjectObjectStorage;
import javax.annotation.Nullable;

public class BatchObjectObjectStorage<K, V, C, KeyElement, ValueElement, KeyIterator>
implements ObjectObjectStorage<K, V>,
CalculableInterceptor,
ObjectObjectCalculatable<K, V> {
    private final ObjectObjectStorage<KeyElement, ValueElement> storage;
    private final KeyStrategy<K, KeyElement, KeyIterator> keyStrategy;
    private final ValueStrategy<KeyElement, V, ValueElement, C> valueStrategy;
    private final Class<V> valueType;
    private ObjectObjectCalculatable<K, V> realCalculable;
    private C composition;
    private K unknownKey;
    private V knownValue;

    protected BatchObjectObjectStorage(ObjectObjectStorage<KeyElement, ValueElement> storage, KeyStrategy<K, KeyElement, KeyIterator> keyStrategy, ValueStrategy<KeyElement, V, ValueElement, C> valueStrategy, Class<V> valueType) {
        this.storage = storage;
        this.keyStrategy = keyStrategy;
        this.valueStrategy = valueStrategy;
        this.valueType = valueType;
    }

    @Override
    public Object load(K key) {
        this.decompose(key);
        if (this.unknownKey == null) {
            V res = this.knownValue;
            this.reset();
            return res;
        }
        return UNDEFINED;
    }

    protected Object loadElement(KeyElement element) {
        return this.storage.load(element);
    }

    @Override
    public Calculable createInterceptedCalculable(Calculable calculable) {
        this.realCalculable = (ObjectObjectCalculatable)calculable;
        return this;
    }

    @Override
    public void save(K key, V value) {
        this.reset();
    }

    void set(V result, K unknownKey, @Nullable C composition) {
        this.knownValue = result;
        this.unknownKey = unknownKey;
        this.composition = composition;
    }

    void reset() {
        this.knownValue = null;
        this.unknownKey = null;
        this.composition = null;
    }

    protected void decompose(K key) {
        KeyStrategy<K, KeyElement, KeyIterator> keyStrategy = this.keyStrategy;
        ValueStrategy<KeyElement, V, ValueElement, C> valueStrategy = this.valueStrategy;
        K unknownKey = keyStrategy.create(key);
        int n = keyStrategy.size(key);
        V knownValues = valueStrategy.createValue(this.valueType, n);
        C composer = valueStrategy.createComposer(n);
        int unknownCount = 0;
        KeyIterator it = keyStrategy.iterator(key);
        for (int i = 0; i < n; ++i) {
            KeyElement k = keyStrategy.get(i, it);
            Object v = this.loadElement(k);
            if (v == UNDEFINED) {
                valueStrategy.addUnknown(knownValues, composer, i, k);
                if (!keyStrategy.put(unknownKey, unknownCount, k)) continue;
                ++unknownCount;
                continue;
            }
            valueStrategy.addKnown(knownValues, composer, i, k, v);
        }
        this.set(knownValues, unknownCount == 0 ? null : (K)keyStrategy.toKey(unknownKey, unknownCount), composer);
    }

    private void saveReal(K unknownKey, V calculated) {
        int n = this.keyStrategy.size(unknownKey);
        KeyIterator it = this.keyStrategy.iterator(unknownKey);
        for (int i = 0; i < n; ++i) {
            KeyElement k = this.keyStrategy.get(i, it);
            this.storage.save(k, this.valueStrategy.get(calculated, i, k));
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    public V calculate(Object owner, K key) {
        try {
            K unknownKey = this.unknownKey;
            V calculated = this.realCalculable.calculate(owner, unknownKey);
            this.saveReal(unknownKey, calculated);
            return this.valueStrategy.compose(this.knownValue, calculated, this.composition);
        }
        catch (RuntimeException e) {
            this.reset();
            throw e;
        }
        catch (Error e) {
            this.reset();
            throw e;
        }
    }
}

