/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.batch;

import com.maxifier.mxcache.impl.caches.batch.ValueStrategy;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

final class ListValueStrategy<K, V>
implements ValueStrategy<K, List<V>, V, BitSet> {
    private static final ListValueStrategy INSTANCE = new ListValueStrategy();

    private ListValueStrategy() {
    }

    public static <K, V> ListValueStrategy<K, V> getInstance() {
        return INSTANCE;
    }

    @Override
    public List<V> compose(List<V> knownValue, List<V> calculated, BitSet composition) {
        int i = composition.nextSetBit(0);
        int p = 0;
        while (i >= 0) {
            knownValue.set(i, calculated.get(p));
            i = composition.nextSetBit(i + 1);
            ++p;
        }
        return knownValue;
    }

    @Override
    public List<V> createValue(Class<List<V>> valueType, int n) {
        return new ArrayList(n);
    }

    @Override
    public BitSet createComposer(int n) {
        return new BitSet(n);
    }

    @Override
    public void addUnknown(List<V> knownValues, BitSet composer, int i, K k) {
        composer.set(i);
        knownValues.add(null);
    }

    @Override
    public void addKnown(List<V> knownValues, BitSet composer, int i, K k, V v) {
        knownValues.add(v);
    }

    @Override
    public V get(List<V> value, int index, K key) {
        return value.get(index);
    }

    @Override
    public boolean requiresOrder() {
        return true;
    }
}

