/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.def;

import com.maxifier.mxcache.impl.caches.def.ObjectCharacterTroveStorage;
import com.maxifier.mxcache.transform.SmartReference;
import com.maxifier.mxcache.tuple.Tuple;
import gnu.trove.strategy.HashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TupleCharacterWeakTroveStorage
extends ObjectCharacterTroveStorage<Tuple> {
    private final List<Tuple> removed = Collections.synchronizedList(new ArrayList());
    private final int[] tupleIndices;

    public TupleCharacterWeakTroveStorage() {
        throw new UnsupportedOperationException("TupleCharacterWeakTroveStorage actually is not externalizable");
    }

    public TupleCharacterWeakTroveStorage(int[] tupleIndices) {
        this.tupleIndices = tupleIndices;
    }

    public TupleCharacterWeakTroveStorage(HashingStrategy<Tuple> strategy, int[] tupleIndices) {
        super(strategy);
        this.tupleIndices = tupleIndices;
    }

    private void cleanup() {
        for (Tuple t : this.removed) {
            this.remove(t);
        }
        this.removed.clear();
    }

    @Override
    public char load(Tuple o) {
        this.cleanup();
        return super.load(o);
    }

    @Override
    public void save(Tuple o, char t) {
        this.cleanup();
        Callback callback = new Callback(o);
        for (int index : this.tupleIndices) {
            ((SmartReference)o.get(index)).setCallback(callback);
        }
        super.save(o, t);
    }

    private class Callback
    implements Runnable {
        private final Tuple o;

        public Callback(Tuple o) {
            this.o = o;
        }

        @Override
        public void run() {
            TupleCharacterWeakTroveStorage.this.removed.add(this.o);
        }
    }
}

