/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.resource;

import com.maxifier.mxcache.InternalProbeFailedError;
import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.impl.resource.CollectingChangedDependencyNodeVisitor;
import com.maxifier.mxcache.impl.resource.CollectingDependencyNodeVisitor;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyNodeVisitor;
import com.maxifier.mxcache.impl.resource.MxResourceImpl;
import com.maxifier.mxcache.impl.resource.ResourceViewDependencyNodeVisitor;
import com.maxifier.mxcache.resource.MxResource;
import com.maxifier.mxcache.util.HashWeakReference;
import com.maxifier.mxcache.util.TIdentityHashSet;
import gnu.trove.set.hash.THashSet;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DependencyTracker {
    private static final ThreadLocal<DependencyNode> NODE = new ThreadLocal();
    private static final ThreadLocal<TIdentityHashSet<CleaningNode>> RESOURCE_VIEW_NODES = new ThreadLocal();
    public static final DependencyNode DUMMY_NODE = new DummyDependencyNode("<DUMMY>");
    public static final DependencyNode PROBE_NODE = new DummyDependencyNode("<PROBE>");
    public static final DependencyNode NOCACHE_NODE = new DummyDependencyNode("<NOCACHE>");
    public static final DependencyNode HIDDEN_CALLER_NODE = new HiddenCallerDependencyNode();

    private DependencyTracker() {
    }

    public static void mark(DependencyNode node) {
        if (node != DUMMY_NODE) {
            DependencyTracker.track(node, NODE.get());
        }
    }

    public static DependencyNode track(DependencyNode node) {
        DependencyNode oldNode = NODE.get();
        assert (oldNode == null || node != null) : "Could not reassign node to null";
        if (oldNode == PROBE_NODE) {
            throw new InternalProbeFailedError();
        }
        if (node != DUMMY_NODE) {
            DependencyTracker.track(node, oldNode);
            NODE.set(node);
        } else if (oldNode == null) {
            NODE.set(node);
        }
        return oldNode;
    }

    private static void track(DependencyNode node, DependencyNode oldNode) {
        if (oldNode != null && oldNode != DUMMY_NODE && node != oldNode) {
            node.trackDependency(oldNode);
        }
    }

    public static void exit(@Nullable DependencyNode callerNode) {
        NODE.set(callerNode);
    }

    public static DependencyNode get() {
        return NODE.get();
    }

    public static boolean hasUnderlyingNode() {
        return NODE.get() != null;
    }

    public static void addExplicitDependency(DependencyNode node, MxResource resource) {
        if (!(resource instanceof MxResourceImpl)) {
            throw new UnsupportedOperationException("Current implementation of dependency tracker cannot deal with resource class " + resource.getClass());
        }
        ((MxResourceImpl)resource).trackDependency(node);
    }

    public static TIdentityHashSet<CleaningNode> saveResourceViewNodes(DependencyNode node) {
        TIdentityHashSet<CleaningNode> oldNodes = RESOURCE_VIEW_NODES.get();
        RESOURCE_VIEW_NODES.set(DependencyTracker.getResourceViewDependentNodes(node));
        return oldNodes;
    }

    public static boolean isDependentResourceView(CleaningNode node) {
        TIdentityHashSet<CleaningNode> cleaningNodes = RESOURCE_VIEW_NODES.get();
        return cleaningNodes != null && cleaningNodes.contains(node);
    }

    public static void exitDependentResourceView(TIdentityHashSet<CleaningNode> oldNodes) {
        RESOURCE_VIEW_NODES.set(oldNodes);
    }

    public static TIdentityHashSet<CleaningNode> getAllDependentNodes(Iterable<DependencyNode> src) {
        return DependencyTracker.getAllDependentNodes(src, Collections.emptySet());
    }

    public static TIdentityHashSet<CleaningNode> getAllDependentNodes(Iterable<DependencyNode> src, Collection<? extends CleaningNode> initial) {
        THashSet nodes = new THashSet();
        LinkedList<DependencyNode> queue = new LinkedList<DependencyNode>();
        CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor((Set<DependencyNode>)nodes, queue);
        return DependencyTracker.getDependentNodes(src, initial, visitor);
    }

    public static TIdentityHashSet<CleaningNode> getResourceViewDependentNodes(DependencyNode sourceNode) {
        THashSet resourceViewableNodes = new THashSet();
        LinkedList<DependencyNode> queue = new LinkedList<DependencyNode>();
        ResourceViewDependencyNodeVisitor visitor = new ResourceViewDependencyNodeVisitor((Set<DependencyNode>)resourceViewableNodes, queue);
        return DependencyTracker.getDependentNodes(Collections.singleton(sourceNode), Collections.emptySet(), visitor);
    }

    public static TIdentityHashSet<CleaningNode> getChangedDependentNodes(DependencyNode sourceNode) {
        THashSet nodes = new THashSet();
        LinkedList<DependencyNode> queue = new LinkedList<DependencyNode>();
        CollectingChangedDependencyNodeVisitor visitor = new CollectingChangedDependencyNodeVisitor((Set<DependencyNode>)nodes, queue);
        return DependencyTracker.getDependentNodes(Collections.singleton(sourceNode), Collections.emptySet(), visitor);
    }

    private static TIdentityHashSet<CleaningNode> getDependentNodes(Iterable<DependencyNode> src, Collection<? extends CleaningNode> initial, DependencyNodeVisitor visitor) {
        for (DependencyNode node : src) {
            node.visitDependantNodes(visitor);
        }
        Queue<DependencyNode> queue = visitor.getQueue();
        while (!queue.isEmpty()) {
            queue.poll().visitDependantNodes(visitor);
        }
        Set<DependencyNode> nodes = visitor.getNodes();
        TIdentityHashSet<CleaningNode> result = new TIdentityHashSet<CleaningNode>(nodes.size() + initial.size());
        result.addAll(initial);
        for (DependencyNode node : nodes) {
            node.appendNodes(result);
        }
        return result;
    }

    public static boolean isDummyNode(DependencyNode node) {
        return node instanceof DummyDependencyNode;
    }

    public static boolean isBypassCaches() {
        return NOCACHE_NODE.equals(DependencyTracker.get());
    }

    private static class HiddenCallerDependencyNode
    implements DependencyNode {
        private final Reference<DependencyNode> thisReference = new WeakReference<HiddenCallerDependencyNode>(this);

        private HiddenCallerDependencyNode() {
        }

        @Override
        public Reference<DependencyNode> getSelfReference() {
            return this.thisReference;
        }

        @Override
        public void visitDependantNodes(DependencyNodeVisitor visitor) {
        }

        @Override
        public void appendNodes(TIdentityHashSet<CleaningNode> elements) {
        }

        @Override
        public void trackDependency(DependencyNode node) {
        }

        @Override
        public void addNode(@Nonnull CleaningNode cache) {
        }

        public String toString() {
            return "HiddenCaller - see MxCache.hideCallerDependencies";
        }
    }

    private static final class DummyDependencyNode
    implements DependencyNode {
        private final Reference<DependencyNode> selfReference = new HashWeakReference<DummyDependencyNode>(this);
        private final String name;

        private DummyDependencyNode(String name) {
            this.name = name;
        }

        @Override
        public void visitDependantNodes(DependencyNodeVisitor visitor) {
        }

        @Override
        public void appendNodes(TIdentityHashSet<CleaningNode> elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void trackDependency(DependencyNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addNode(@Nonnull CleaningNode cache) {
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Reference<DependencyNode> getSelfReference() {
            return this.selfReference;
        }
    }
}

