/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.resource.nodes;

import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.caches.DoubleCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.nodes.MultipleDependencyNode;
import com.maxifier.mxcache.impl.resource.nodes.ResourceViewable;
import com.maxifier.mxcache.storage.DoubleStorage;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewableMultipleDoubleDependencyNode
extends MultipleDependencyNode
implements ResourceViewable {
    private static final Logger logger = LoggerFactory.getLogger(ViewableMultipleDoubleDependencyNode.class);

    @Override
    public synchronized void addNode(@Nonnull CleaningNode cache) {
        super.addNode(cache);
        if (!(cache instanceof DoubleStorage)) {
            String owner = "";
            if (cache instanceof Cache) {
                owner = ((Cache)cache).getDescriptor().toString();
            }
            logger.error("@ResourceView is incorrect specified for method {}. Return type {} is not supported by ResourceView", (Object)owner, cache.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChanged() {
        DependencyNode prevNode = DependencyTracker.track(DependencyTracker.NOCACHE_NODE);
        try {
            for (WeakReference ref : this.instances) {
                CleaningNode node = (CleaningNode)ref.get();
                if (node == null) continue;
                if (node instanceof DoubleStorage && node instanceof DoubleCache) {
                    DoubleStorage storage = (DoubleStorage)((Object)node);
                    DoubleCache cache = (DoubleCache)node;
                    if (!storage.isCalculated() || DependencyTracker.isDependentResourceView(cache) || cache.getOrCreate() == storage.load()) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            DependencyTracker.exit(prevNode);
        }
        return false;
    }
}

