/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.resource.nodes;

import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.caches.DoubleCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.nodes.ResourceViewable;
import com.maxifier.mxcache.impl.resource.nodes.SingletonDependencyNode;
import com.maxifier.mxcache.storage.DoubleStorage;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewableSingletonDoubleDependencyNode
extends SingletonDependencyNode
implements ResourceViewable {
    private static final Logger logger = LoggerFactory.getLogger(ViewableSingletonDoubleDependencyNode.class);

    @Override
    public synchronized void addNode(@Nonnull CleaningNode cache) {
        super.addNode(cache);
        if (!(cache instanceof DoubleStorage)) {
            String owner = "";
            if (cache instanceof Cache) {
                owner = ((Cache)cache).getDescriptor().toString();
            }
            logger.error("@ResourceView is incorrect specified for method {}. Return type {} is not supported by ResourceView", (Object)owner, cache.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChanged() {
        if (this.instance instanceof DoubleStorage && this.instance instanceof DoubleCache) {
            DoubleStorage storage = (DoubleStorage)((Object)this.instance);
            DoubleCache cache = (DoubleCache)this.instance;
            DependencyNode prevNode = DependencyTracker.track(DependencyTracker.NOCACHE_NODE);
            try {
                boolean bl = storage.isCalculated() && !DependencyTracker.isDependentResourceView(cache) && cache.getOrCreate() != storage.load();
                return bl;
            }
            finally {
                DependencyTracker.exit(prevNode);
            }
        }
        return true;
    }
}

