/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.provider;

import com.maxifier.mxcache.provider.AnnotationProperty;
import com.maxifier.mxcache.provider.PropertyConvertationException;
import com.maxifier.mxcache.util.CodegenHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;

public class ReflectiveAnnotationProperty<A extends Annotation, T>
extends AnnotationProperty<A, T> {
    private final Method method;

    public ReflectiveAnnotationProperty(String name, Class<T> type, T defaultValue, Class<A> annotationType, String annotationPropertyName) {
        this(name, type, defaultValue, annotationType, ReflectiveAnnotationProperty.getMethod(annotationType, annotationPropertyName));
    }

    public ReflectiveAnnotationProperty(String name, Class<T> type, T defaultValue, Class<A> annotationType, Method method) {
        super(name, type, annotationType, defaultValue);
        if (!this.canBeCasted(type, method)) {
            throw new IllegalArgumentException("Method " + method + " cannot be casted to " + type);
        }
        this.method = method;
    }

    private boolean canBeCasted(Class<T> type, Method method) {
        return ReflectiveAnnotationProperty.box(type).isAssignableFrom(ReflectiveAnnotationProperty.box(method.getReturnType()));
    }

    private static Class box(Class type) {
        Class boxed = CodegenHelper.getBoxedType(type);
        return boxed == null ? type : boxed;
    }

    private static <A extends Annotation> Method getMethod(Class<A> annotationClass, String annotationPropertyName) {
        try {
            return annotationClass.getMethod(annotationPropertyName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No such property: " + annotationClass + "." + annotationPropertyName, e);
        }
    }

    @Override
    public T getFromAnnotation(@Nonnull A annotation) {
        try {
            return (T)this.method.invoke(annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new PropertyConvertationException(e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyConvertationException(e);
        }
    }
}

