/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.provider;

import com.maxifier.mxcache.provider.AnnotationProperty;
import com.maxifier.mxcache.provider.ReflectiveAnnotationProperty;
import java.lang.annotation.Annotation;
import javax.annotation.Nonnull;

public class StrategyProperty<T> {
    private final String name;
    private final Class<T> type;
    private final T defaultValue;

    public StrategyProperty(@Nonnull String name, @Nonnull Class<T> type, T defaultValue) {
        if (defaultValue != null && !type.isInstance(defaultValue)) {
            throw new IllegalArgumentException("Invalid defaultValue = " + defaultValue + " for property " + name + ": " + type);
        }
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public StrategyProperty(String name, Class<T> type) {
        this(name, type, null);
    }

    public static <T> StrategyProperty<T> create(@Nonnull String name, @Nonnull Class<T> type, T defaultValue) {
        return new StrategyProperty<T>(name, type, defaultValue);
    }

    public static <T> StrategyProperty<T> create(@Nonnull String name, @Nonnull Class<T> type) {
        return new StrategyProperty<T>(name, type);
    }

    public static <A extends Annotation, T> AnnotationProperty<A, T> create(@Nonnull String name, @Nonnull Class<T> type, Class<A> annotationClass, String annotationPropertyName) {
        return new ReflectiveAnnotationProperty<A, Object>(name, type, null, annotationClass, annotationPropertyName);
    }

    public static <A extends Annotation, T> AnnotationProperty<A, T> create(@Nonnull String name, @Nonnull Class<T> type, T defaultValue, Class<A> annotationClass, String annotationPropertyName) {
        return new ReflectiveAnnotationProperty<A, T>(name, type, defaultValue, annotationClass, annotationPropertyName);
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrategyProperty that = (StrategyProperty)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name + ": " + this.type;
    }
}

