/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.proxy;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.proxy.MxAbstractProxyFactory;
import com.maxifier.mxcache.proxy.MxGenericProxy;
import com.maxifier.mxcache.proxy.Resolvable;
import com.maxifier.mxcache.util.ClassGenerator;
import com.maxifier.mxcache.util.CodegenHelper;
import com.maxifier.mxcache.util.MxConstructorGenerator;
import com.maxifier.mxcache.util.MxGeneratorAdapter;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MxGenericProxyFactory<T, C>
extends MxAbstractProxyFactory {
    private static final Logger logger = LoggerFactory.getLogger(MxGenericProxyFactory.class);
    private static final Type MX_GENERIC_PROXY_TYPE = Type.getType(MxGenericProxy.class);
    private static final Method MX_GENERIC_PROXY_CTOR = new Method("<init>", Type.VOID_TYPE, new Type[]{RESOLVABLE_TYPE, CodegenHelper.CLASS_TYPE, CodegenHelper.CLASS_TYPE, CodegenHelper.CLASS_TYPE});
    private final Class<T> sourceInterface;
    private final Class<C> containerClass;
    private final Map<Class<? extends T>, Constructor<T>> proxyClasses = new THashMap();

    MxGenericProxyFactory(@Nonnull Class<T> sourceInterface, @Nonnull Class<C> containerClass) {
        if (!sourceInterface.isInterface()) {
            throw new IllegalArgumentException("Only interface can be used as proxy source but " + sourceInterface + " was passed");
        }
        if (!Resolvable.class.isAssignableFrom(containerClass)) {
            throw new IllegalArgumentException("Container " + containerClass + " should implement " + Resolvable.class);
        }
        this.sourceInterface = sourceInterface;
        this.containerClass = containerClass;
    }

    private synchronized Constructor<? extends T> getOrCreateProxy(Class<? extends T> cls) {
        Constructor<Object> proxyInfo = this.proxyClasses.get(cls);
        if (proxyInfo == null) {
            Class<T> proxyClass = this.createProxyClass(cls, this.containerClass);
            try {
                proxyInfo = proxyClass.getConstructor(this.containerClass);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.proxyClasses.put(cls, proxyInfo);
        }
        return proxyInfo;
    }

    public Class<T> getSourceInterface() {
        return this.sourceInterface;
    }

    public Class<?> getContainerClass() {
        return this.containerClass;
    }

    public T createProxy(Class<? extends T> srcClass, C container) {
        try {
            return this.getOrCreateProxy(srcClass).newInstance(container);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create proxy for " + container, e);
        }
    }

    private Class<T> createProxyClass(Class<? extends T> sourceClass, Class<C> containerClass) {
        long start = System.currentTimeMillis();
        try {
            Set<Class<Class>> interfaces = this.getAllProxiedInterfaces(sourceClass);
            String proxyClassName = MxGenericProxyFactory.createProxyClassName(sourceClass);
            Type containerType = Type.getType(containerClass);
            ClassGenerator proxyClass = new ClassGenerator(33, proxyClassName, MxGenericProxy.class, interfaces.toArray(new Class[interfaces.size()]));
            this.createProxyConstructor(sourceClass, containerClass, proxyClass, containerType);
            this.createMethodProxies(containerClass, interfaces, proxyClass, containerType);
            Class newClass = proxyClass.toClass(sourceClass.getClassLoader());
            long end = System.currentTimeMillis();
            logger.debug("Generated generic proxy for " + sourceClass + "[" + this.sourceInterface + ", " + interfaces.size() + "] with container " + containerClass + " in " + (end - start) + " ms");
            return newClass;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createMethodProxies(Class<C> containerClass, Set<Class<? extends T>> interfaces, ClassGenerator generator, Type containerType) {
        THashSet methods = new THashSet();
        for (Class<T> intf : interfaces) {
            for (java.lang.reflect.Method sourceMethod : intf.getMethods()) {
                if (!sourceMethod.getDeclaringClass().equals(intf)) continue;
                Class<?> returnType = sourceMethod.getReturnType();
                Class[] args = sourceMethod.getParameterTypes();
                if (!methods.add(new MethodInfo(args, returnType, sourceMethod.getName()))) continue;
                this.createProxyMethod(containerClass, generator, containerType, intf, sourceMethod);
            }
        }
    }

    private Set<Class<? extends T>> getAllProxiedInterfaces(Class<? extends T> sourceClass) {
        THashSet interfaces = new THashSet();
        LinkedList iq = new LinkedList();
        THashSet passed = new THashSet();
        iq.add(sourceClass);
        if (sourceClass.isInterface()) {
            interfaces.add(sourceClass);
        }
        for (Class<?> cls : this.sourceInterface.getInterfaces()) {
            interfaces.add(cls);
        }
        while (!iq.isEmpty()) {
            Class c = (Class)iq.poll();
            if (c.getSuperclass() != null && passed.add(c.getSuperclass())) {
                iq.add(c.getSuperclass());
            }
            for (Class<?> cls : c.getInterfaces()) {
                if (passed.add(cls)) {
                    iq.add(cls);
                }
                if (!this.sourceInterface.isAssignableFrom(cls)) continue;
                interfaces.add(cls);
            }
        }
        return interfaces;
    }

    private void createProxyMethod(Class<C> containerClass, ClassGenerator generator, Type containerType, Class<? extends T> intf, java.lang.reflect.Method sourceMethod) {
        Method sourceMethod0 = Method.getMethod((java.lang.reflect.Method)sourceMethod);
        MxGeneratorAdapter method = generator.defineMethod(1, sourceMethod0);
        method.start();
        method.loadThis();
        method.getField(MX_GENERIC_PROXY_TYPE, "value", RESOLVABLE_TYPE);
        method.checkCast(containerType);
        method.invokeVirtual(Type.getType(containerClass), GETTER);
        method.loadArgs();
        method.invokeInterface(Type.getType(intf), sourceMethod0);
        method.returnValue();
        method.endMethod();
    }

    private void createProxyConstructor(Class<? extends T> sourceClass, Class<C> containerClass, ClassGenerator generator, Type containerType) {
        MxConstructorGenerator ctor = generator.defineConstructor(1, containerType);
        ctor.start();
        ctor.loadThis();
        ctor.loadArg(0);
        ctor.push(Type.getType(sourceClass));
        ctor.push(Type.getType(containerClass));
        ctor.push(Type.getType(this.sourceInterface));
        ctor.invokeConstructor(MX_GENERIC_PROXY_TYPE, MX_GENERIC_PROXY_CTOR);
        ctor.returnValue();
        ctor.endMethod();
    }

    public String toString() {
        return "ProxyFactory for " + this.sourceInterface + " wrapped in " + this.containerClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MxGenericProxyFactory)) {
            return false;
        }
        MxGenericProxyFactory that = (MxGenericProxyFactory)o;
        return this.containerClass == that.containerClass && this.sourceInterface == that.sourceInterface;
    }

    public int hashCode() {
        return 31 * this.sourceInterface.hashCode() + this.containerClass.hashCode();
    }

    private final class MethodInfo {
        private final Class[] argTypes;
        private final Class returnType;
        private final String name;
        private final int hash;

        MethodInfo(Class[] argTypes, Class returnType, String name) {
            this.argTypes = argTypes;
            this.returnType = returnType;
            this.name = name;
            this.hash = Arrays.hashCode(argTypes) ^ returnType.hashCode() ^ name.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            MethodInfo info = (MethodInfo)obj;
            return this.hash == info.hash && this.returnType == info.returnType && this.name.equals(info.name) && Arrays.equals(this.argTypes, info.argTypes);
        }
    }
}

