/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.proxy;

import com.maxifier.mxcache.proxy.MxGenericProxyFactory;
import com.maxifier.mxcache.proxy.MxProxyFactory;
import com.maxifier.mxcache.proxy.Resolvable;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public final class MxProxyGenerator {
    private static final Map<MxProxyFactory, MxProxyFactory> PROXY_MAP = new THashMap();
    private static final Map<MxGenericProxyFactory, MxGenericProxyFactory> GENERIC_PROXY_MAP = new THashMap();

    private MxProxyGenerator() {
    }

    public static synchronized <T, C extends Resolvable<T>> MxProxyFactory<T, C> getProxyFactory(Class<T> sourceClass, Class<C> containerClass) {
        MxProxyFactory<T, C> proxy = new MxProxyFactory<T, C>(sourceClass, containerClass);
        MxProxyFactory oldProxy = PROXY_MAP.get(proxy);
        if (oldProxy == null) {
            PROXY_MAP.put(proxy, proxy);
            return proxy;
        }
        return oldProxy;
    }

    public static synchronized <T, C extends Resolvable<T>> MxGenericProxyFactory<T, C> getGenericProxyFactory(Class<T> sourceClass, Class<C> containerClass) {
        MxGenericProxyFactory<T, C> proxy = new MxGenericProxyFactory<T, C>(sourceClass, containerClass);
        MxGenericProxyFactory oldProxy = GENERIC_PROXY_MAP.get(proxy);
        if (oldProxy == null) {
            GENERIC_PROXY_MAP.put(proxy, proxy);
            return proxy;
        }
        return oldProxy;
    }
}

