/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.proxy;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.util.CodegenHelper;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProxyMappingKey {
    private static final Logger logger = LoggerFactory.getLogger(ProxyMappingKey.class);
    private final Class owner;
    private final String name;
    private final String desc;

    ProxyMappingKey(Method method) {
        this.owner = method.getDeclaringClass();
        this.name = method.getName();
        this.desc = Type.getMethodDescriptor((Method)method);
    }

    ProxyMappingKey(Class owner, String name, String desc) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyMappingKey that = (ProxyMappingKey)o;
        return this.owner == that.owner && this.name.equals(that.name) && this.desc.equals(that.desc);
    }

    public int hashCode() {
        int result = this.owner.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.desc.hashCode();
        return result;
    }

    public Method getMethod() {
        try {
            return this.owner.getDeclaredMethod(this.name, CodegenHelper.getClasses(this.owner.getClassLoader(), Type.getArgumentTypes((String)this.desc)));
        }
        catch (NoSuchMethodException e) {
            logger.error("Cannot create proxy factory for " + this, (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.owner.getCanonicalName() + "." + this.name + this.desc;
    }
}

