/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.proxy;

import com.maxifier.mxcache.proxy.MxProxyGenerator;
import com.maxifier.mxcache.proxy.ProxyFactory;
import com.maxifier.mxcache.proxy.Resolvable;
import java.lang.ref.WeakReference;

public class WeakProxyFactory<Value>
implements ProxyFactory<Value> {
    @Override
    public Value proxy(Class<Value> expected, Resolvable<Value> resolvable) {
        return MxProxyGenerator.getProxyFactory(expected, WeakResolvable.class).createProxy(new WeakResolvable<Value>(resolvable));
    }

    public static class WeakResolvable<T>
    implements Resolvable<T> {
        private static final Object NON_INITIALIZED = new Object();
        private final Resolvable<T> resolvable;
        private WeakReference<T> cached;

        public WeakResolvable(Resolvable<T> resolvable) {
            this.resolvable = resolvable;
        }

        @Override
        public T getValue() {
            Object value = this.load();
            if (value == NON_INITIALIZED) {
                T t = this.resolvable.getValue();
                this.save(t);
                return t;
            }
            return (T)value;
        }

        private synchronized Object load() {
            if (this.cached == null) {
                return NON_INITIALIZED;
            }
            Object v = this.cached.get();
            if (v == null) {
                return NON_INITIALIZED;
            }
            return v;
        }

        private synchronized void save(T value) {
            this.cached = new WeakReference<T>(value);
        }
    }
}

