/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.scheduler;

import com.maxifier.mxcache.scheduler.MxScheduler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MxSchedulerImpl
implements MxScheduler {
    private static final Logger logger = LoggerFactory.getLogger(MxSchedulerImpl.class);
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingDeque<Runnable>();
    private Thread schedulerThread;

    @Override
    public synchronized void schedule(Runnable runnable) {
        this.tasks.offer(runnable);
        if (this.schedulerThread == null || !this.schedulerThread.isAlive()) {
            this.startThread();
        }
    }

    private void startThread() {
        this.schedulerThread = new Thread((Runnable)new SchedulerRunner(), "MxCache IO Scheduler");
        this.schedulerThread.setDaemon(true);
        this.schedulerThread.start();
    }

    private class SchedulerRunner
    implements Runnable {
        private SchedulerRunner() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        Runnable r = (Runnable)MxSchedulerImpl.this.tasks.take();
                        try {
                            r.run();
                            continue block4;
                        }
                        catch (Throwable e) {
                            logger.error("Cannot execute scheduled task " + r, e);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

