/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.transform;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.GeneratorAdapter;
import com.maxifier.mxcache.transform.ScalarTransformGenerator;
import com.maxifier.mxcache.util.ClassGenerator;
import javax.annotation.Nonnull;

public class BoxTransformGenerator
extends ScalarTransformGenerator {
    private final Type type;

    public BoxTransformGenerator(@Nonnull Type type) {
        this.type = type;
    }

    @Override
    public void generateForward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        method.box(this.type);
    }

    @Override
    public void generateBackward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        method.unbox(this.type);
    }

    @Override
    public void generateFields(Type thisType, int fieldIndex, ClassGenerator writer) {
    }

    @Override
    public void generateAcquire(Type thisType, int fieldIndex, GeneratorAdapter ctor, int contextLocal) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public Class getTransformedType(Class in) {
        return Object.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxTransformGenerator that = (BoxTransformGenerator)o;
        return this.type.equals((Object)that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "box " + this.type.getClassName();
    }
}

