/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.transform;

import com.maxifier.mxcache.InstanceProvider;
import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.GeneratorAdapter;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.transform.InvocationType;
import com.maxifier.mxcache.transform.ScalarTransformGenerator;
import com.maxifier.mxcache.util.ClassGenerator;
import com.maxifier.mxcache.util.CodegenHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExternalTransformGenerator
extends ScalarTransformGenerator {
    private static final String TRANSFORMATOR_FIELD = "transformator";
    private static final Type INSTANCE_PROVIDER_TYPE = Type.getType(InstanceProvider.class);
    private static final Type CACHE_CONTEXT_TYPE = Type.getType(CacheContext.class);
    private static final Method GET_INSTANCE_PROVIDER_METHOD = new Method("getInstanceProvider", INSTANCE_PROVIDER_TYPE, CodegenHelper.EMPTY_TYPES);
    private static final Method FOR_CLASS_METHOD = Method.getMethod((String)"Object forClass(Class)");
    @Nonnull
    private final InvocationType invocationType;
    @Nonnull
    private final Type ownerType;
    @Nonnull
    private final java.lang.reflect.Method method;
    @Nullable
    private final Type keyType;

    public ExternalTransformGenerator(@Nonnull InvocationType invocationType, @Nonnull Class owner, @Nonnull java.lang.reflect.Method method) {
        this.invocationType = invocationType;
        this.ownerType = Type.getType((Class)owner);
        this.method = method;
        Type[] argTypes = Type.getArgumentTypes((java.lang.reflect.Method)method);
        if (invocationType == InvocationType.KEY_INTERFACE || invocationType == InvocationType.KEY_VIRTUAL) {
            if (argTypes.length != 0) {
                throw new IllegalArgumentException("Transformator method of key should have no arguments");
            }
            this.keyType = null;
        } else {
            if (argTypes.length != 1) {
                throw new IllegalArgumentException("Transformator method should have exactly one argument");
            }
            this.keyType = argTypes[0];
        }
        if (method.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("Transformator method shouldn't return void");
        }
    }

    @Override
    public void generateForward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        if (this.invocationType.isKeyInvocation()) {
            method.checkCast(this.ownerType);
        } else if (this.invocationType.isRequiresKey() && CodegenHelper.isReferenceType(this.keyType)) {
            method.checkCast(this.keyType);
        }
        if (this.invocationType.isNeedsField()) {
            method.loadThis();
            method.getField(thisType, TRANSFORMATOR_FIELD + fieldIndex, this.ownerType);
            method.swap(this.keyType, CodegenHelper.OBJECT_TYPE);
        }
        method.visitMethodInsn(this.invocationType.getOpcode(), this.ownerType.getInternalName(), this.method.getName(), Type.getMethodDescriptor((java.lang.reflect.Method)this.method));
    }

    @Override
    public void generateBackward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateFields(Type thisType, int fieldIndex, ClassGenerator writer) {
        if (this.invocationType.isNeedsField()) {
            writer.defineField(2, TRANSFORMATOR_FIELD + fieldIndex, this.ownerType);
        }
    }

    @Override
    public void generateAcquire(Type thisType, int fieldIndex, GeneratorAdapter ctor, int contextLocal) {
        if (this.invocationType.isNeedsField()) {
            ctor.loadThis();
            ctor.loadLocal(contextLocal);
            ctor.invokeInterface(CACHE_CONTEXT_TYPE, GET_INSTANCE_PROVIDER_METHOD);
            ctor.push(this.ownerType);
            ctor.invokeInterface(INSTANCE_PROVIDER_TYPE, FOR_CLASS_METHOD);
            ctor.checkCast(this.ownerType);
            ctor.putField(thisType, TRANSFORMATOR_FIELD + fieldIndex, this.ownerType);
        }
    }

    @Override
    public int getFieldCount() {
        return this.invocationType.isNeedsField() ? 1 : 0;
    }

    @Override
    public Class getTransformedType(Class in) {
        return this.method.getReturnType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTransformGenerator that = (ExternalTransformGenerator)o;
        return this.method.equals(that.method) && this.invocationType == that.invocationType && (this.keyType == null ? that.keyType == null : this.keyType.equals((Object)that.keyType)) && this.ownerType.equals((Object)that.ownerType);
    }

    public int hashCode() {
        int result = this.invocationType.hashCode();
        result = 31 * result + this.ownerType.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + (this.keyType == null ? 0 : this.keyType.hashCode());
        return result;
    }

    public String toString() {
        return (Object)((Object)this.invocationType) + " " + this.ownerType.getClassName() + "." + this.method;
    }
}

