/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.transform;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.transform.CompositeTransformGenerator;
import com.maxifier.mxcache.transform.CustomTransformAnnotation;
import com.maxifier.mxcache.transform.ExternalTransformGenerator;
import com.maxifier.mxcache.transform.Ignore;
import com.maxifier.mxcache.transform.InvalidTransformAnnotations;
import com.maxifier.mxcache.transform.InvocationType;
import com.maxifier.mxcache.transform.ReversibleTransform;
import com.maxifier.mxcache.transform.Transform;
import com.maxifier.mxcache.transform.TransformFactory;
import com.maxifier.mxcache.transform.TransformGenerator;
import com.maxifier.mxcache.transform.TransformGeneratorFactory;
import com.maxifier.mxcache.transform.TupleTransformGenerator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TransformGeneratorFactoryImpl
implements TransformGeneratorFactory {
    private static final TransformGeneratorFactoryImpl INSTANCE = new TransformGeneratorFactoryImpl();

    private TransformGeneratorFactoryImpl() {
    }

    public static TransformGeneratorFactoryImpl getInstance() {
        return INSTANCE;
    }

    @Override
    @Nonnull
    public TransformGenerator forMethod(Method method) throws InvalidTransformAnnotations {
        try {
            Class[] params = method.getParameterTypes();
            switch (params.length) {
                case 0: {
                    return TransformGenerator.NO_TRANSFORM;
                }
                case 1: {
                    return this.forArgument(method.getParameterAnnotations()[0], params[0]);
                }
            }
            return this.createMultiParam(method.getParameterAnnotations(), params);
        }
        catch (InvalidTransformAnnotations e) {
            throw new InvalidTransformAnnotations("Cannot create transform generator for " + method, e);
        }
    }

    @Override
    @Nonnull
    public TransformGenerator forArgument(Annotation[] annotations, Class argType) throws InvalidTransformAnnotations {
        ArrayList<TransformGeneratorRef> refs = new ArrayList<TransformGeneratorRef>();
        for (Annotation annotation : annotations) {
            TransformGeneratorRef res = this.forAnnotation(argType, annotation);
            if (res == null) continue;
            refs.add(res);
        }
        if (refs.isEmpty()) {
            return TransformGenerator.NO_TRANSFORM;
        }
        if (refs.size() > 1) {
            throw new InvalidTransformAnnotations("Too many transform annotations: " + refs);
        }
        return ((TransformGeneratorRef)refs.get(0)).get(annotations);
    }

    @Nullable
    private TransformGeneratorRef forAnnotation(Class argType, Annotation annotation) {
        if (annotation instanceof Ignore) {
            return new ConstTransformGeneratorRef<Ignore>((Ignore)annotation, argType, TransformGenerator.IGNORE_TRANSFORM);
        }
        if (annotation instanceof Transform) {
            return new SimpleTransformGeneratorRef((Transform)annotation, argType);
        }
        if (annotation instanceof ReversibleTransform) {
            return new ReversibleTransformGeneratorRef((ReversibleTransform)annotation, argType);
        }
        return this.forCustomTransformAnnotation(argType, annotation);
    }

    @Nullable
    private TransformGeneratorRef forCustomTransformAnnotation(Class argType, Annotation annotation) {
        CustomTransformAnnotation a = annotation.annotationType().getAnnotation(CustomTransformAnnotation.class);
        Transform t = annotation.annotationType().getAnnotation(Transform.class);
        ReversibleTransform r = annotation.annotationType().getAnnotation(ReversibleTransform.class);
        if (a != null) {
            if (t != null) {
                throw new InvalidTransformAnnotations(annotation.annotationType() + " has both @CustomTransformAnnotation and @Transform");
            }
            if (r != null) {
                throw new InvalidTransformAnnotations(annotation.annotationType() + " has both @CustomTransformAnnotation and @ReversibleTransform");
            }
            return new CustomTranformGeneratorRef(annotation, argType, a);
        }
        if (t != null) {
            if (r != null) {
                throw new InvalidTransformAnnotations(annotation.annotationType() + " has both @Transform and @ReversibleTransform");
            }
            return new IndirectTransformGeneratorRef(annotation, argType, t);
        }
        if (r != null) {
            return new IndirectReversibleTransformGeneratorRef(annotation, argType, r);
        }
        return null;
    }

    @Nonnull
    TransformGenerator createMultiParam(Annotation[][] paramAnnotations, Class[] params) throws InvalidTransformAnnotations {
        boolean onlyNoTransforms = true;
        TransformGenerator[] transformGenerators = new TransformGenerator[params.length];
        Class[] transformedParams = Arrays.copyOf(params, params.length);
        int outParams = 0;
        for (int i = 0; i < paramAnnotations.length; ++i) {
            Annotation[] paramAnnotation = paramAnnotations[i];
            Class paramType = params[i];
            TransformGenerator transformGenerator = this.forArgument(paramAnnotation, paramType);
            if (transformGenerator == TransformGenerator.NO_TRANSFORM) {
                transformedParams[outParams++] = paramType;
                continue;
            }
            onlyNoTransforms = false;
            transformGenerators[i] = transformGenerator;
            if (transformGenerator == TransformGenerator.IGNORE_TRANSFORM) continue;
            transformedParams[outParams++] = transformGenerator.getTransformedType(paramType);
        }
        if (onlyNoTransforms) {
            return TransformGenerator.NO_TRANSFORM;
        }
        transformedParams = outParams != transformedParams.length ? Arrays.copyOf(transformedParams, outParams) : transformedParams;
        return new TupleTransformGenerator(transformGenerators, params, transformedParams);
    }

    @Override
    public TransformGenerator getTransformator(Class param, @Nonnull Transform key) {
        Class owner = key.owner();
        String name = key.method();
        return this.getTransformator(param, owner == Transform.KEY_ITSELF.class ? null : owner, name.equals("<the only public method>") ? null : name);
    }

    @Override
    public TransformGenerator getTransformator(Class<?> paramType, Class owner, String name) {
        boolean keyInstanceMethods;
        boolean bl = keyInstanceMethods = owner == null;
        if (keyInstanceMethods) {
            owner = paramType;
        }
        Method method = TransformGeneratorFactoryImpl.findMethod(owner, name, paramType, keyInstanceMethods);
        InvocationType invocationType = this.getKeyInvocationType(owner, method, keyInstanceMethods);
        return new ExternalTransformGenerator(invocationType, owner, method);
    }

    private InvocationType getKeyInvocationType(Class owner, Method forwardMethod, boolean keyInstanceMethods) {
        switch (forwardMethod.getParameterTypes().length) {
            case 0: {
                return this.getZeroArgKeyInvocationType(owner, forwardMethod, keyInstanceMethods);
            }
            case 1: {
                return this.getSingleArgKeyInvocationType(owner, forwardMethod, keyInstanceMethods);
            }
        }
        throw new IllegalArgumentException("Invalid transform found: " + forwardMethod);
    }

    private InvocationType getZeroArgKeyInvocationType(Class owner, Method forwardMethod, boolean keyInstanceMethods) {
        if (!keyInstanceMethods) {
            throw new IllegalArgumentException("Invalid transform found: " + forwardMethod);
        }
        return owner.isInterface() ? InvocationType.KEY_INTERFACE : InvocationType.KEY_VIRTUAL;
    }

    private InvocationType getSingleArgKeyInvocationType(Class owner, Method forwardMethod, boolean keyInstanceMethods) {
        if (Modifier.isStatic(forwardMethod.getModifiers())) {
            return InvocationType.STATIC;
        }
        if (keyInstanceMethods) {
            throw new IllegalArgumentException("Invalid transform found: " + forwardMethod);
        }
        return owner.isInterface() ? InvocationType.INTERFACE : InvocationType.VIRTUAL;
    }

    static Method findMethod(Class owner, String name, Class paramType, boolean keyInstanceMethods) {
        Method[] methods = owner.getMethods();
        List<Method> suitable = TransformGeneratorFactoryImpl.getSuitableMethods(name, paramType, keyInstanceMethods, methods);
        if (suitable.isEmpty()) {
            String ref = owner + "." + (name == null ? "<only public>" : name);
            throw new IllegalArgumentException("No such public method " + ref + "(? super " + paramType.getCanonicalName() + (keyInstanceMethods ? ") or " + ref + "()" : ")"));
        }
        if (suitable.size() > 1) {
            String ref = owner + "." + (name == null ? "<only public>" : name);
            throw new IllegalArgumentException("Too many public methods " + ref + "(? super " + paramType.getCanonicalName() + (keyInstanceMethods ? ") or " + ref + "(): " : "): ") + suitable);
        }
        return suitable.get(0);
    }

    private static List<Method> getSuitableMethods(String name, Class paramType, boolean keyInstanceMethods, Method[] methods) {
        ArrayList<Method> suitable = new ArrayList<Method>();
        for (Method method : methods) {
            if (!TransformGeneratorFactoryImpl.nameMatches(name, method) || !TransformGeneratorFactoryImpl.isParamsSuites(paramType, keyInstanceMethods, method)) continue;
            suitable.add(method);
        }
        return suitable;
    }

    private static boolean isParamsSuites(Class paramType, boolean keyInstanceMethods, Method method) {
        Class<?>[] params = method.getParameterTypes();
        switch (params.length) {
            case 0: {
                return keyInstanceMethods && !Modifier.isStatic(method.getModifiers());
            }
            case 1: {
                return (!keyInstanceMethods || Modifier.isStatic(method.getModifiers())) && params[0].isAssignableFrom(paramType);
            }
        }
        return false;
    }

    private static boolean nameMatches(String name, Method method) {
        return name == null ? !TransformGeneratorFactoryImpl.isObjectMethod(method) : method.getName().equals(name);
    }

    private static boolean isObjectMethod(Method method) {
        String name = method.getName();
        Object[] parameters = method.getParameterTypes();
        for (Method o : Object.class.getMethods()) {
            if (!name.equals(o.getName()) || !Arrays.equals(parameters, o.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    private final class ReversibleTransformGeneratorRef
    extends TransformGeneratorRef<ReversibleTransform> {
        ReversibleTransformGeneratorRef(ReversibleTransform annotation, Class paramType) {
            super(annotation, paramType);
        }

        @Override
        TransformGenerator get(Annotation[] allAnnotations) {
            TransformGenerator forward = TransformGeneratorFactoryImpl.this.getTransformator(this.paramType, ((ReversibleTransform)this.annotation).forward());
            TransformGenerator backward = TransformGeneratorFactoryImpl.this.getTransformator(forward.getTransformedType(this.paramType), ((ReversibleTransform)this.annotation).backward());
            return new CompositeTransformGenerator(forward, backward);
        }
    }

    private static final class CustomTranformGeneratorRef
    extends TransformGeneratorRef<Annotation> {
        private final CustomTransformAnnotation customTransform;

        CustomTranformGeneratorRef(Annotation annotation, Class paramType, CustomTransformAnnotation customTransform) {
            super(annotation, paramType);
            this.customTransform = customTransform;
        }

        @Override
        TransformGenerator get(Annotation[] allAnnotations) {
            Class<? extends TransformFactory> generatorClass = this.customTransform.transformGenerator();
            return CacheFactory.getDefaultContext().getInstanceProvider().forClass(generatorClass).create(this.customTransform, allAnnotations, this.paramType);
        }
    }

    private final class IndirectReversibleTransformGeneratorRef
    extends TransformGeneratorRef<Annotation> {
        private final ReversibleTransformGeneratorRef ref;

        IndirectReversibleTransformGeneratorRef(Annotation annotation, Class paramType, ReversibleTransform transform) {
            super(annotation, paramType);
            this.ref = new ReversibleTransformGeneratorRef(transform, paramType);
        }

        @Override
        TransformGenerator get(Annotation[] allAnnotations) {
            return this.ref.get(allAnnotations);
        }
    }

    private final class IndirectTransformGeneratorRef
    extends TransformGeneratorRef<Annotation> {
        private final SimpleTransformGeneratorRef ref;

        IndirectTransformGeneratorRef(Annotation annotation, Class paramType, Transform transform) {
            super(annotation, paramType);
            this.ref = new SimpleTransformGeneratorRef(transform, paramType);
        }

        @Override
        TransformGenerator get(Annotation[] allAnnotations) {
            return this.ref.get(allAnnotations);
        }
    }

    private class SimpleTransformGeneratorRef
    extends TransformGeneratorRef<Transform> {
        SimpleTransformGeneratorRef(Transform annotation, Class paramType) {
            super(annotation, paramType);
        }

        @Override
        TransformGenerator get(Annotation[] allAnnotations) {
            return TransformGeneratorFactoryImpl.this.getTransformator(this.paramType, (Transform)this.annotation);
        }
    }

    private static class ConstTransformGeneratorRef<T extends Annotation>
    extends TransformGeneratorRef<T> {
        private final TransformGenerator generator;

        public ConstTransformGeneratorRef(T annotation, Class argType, TransformGenerator generator) {
            super(annotation, argType);
            this.generator = generator;
        }

        @Override
        TransformGenerator get(Annotation[] allAnnotations) {
            return this.generator;
        }
    }

    private static abstract class TransformGeneratorRef<A extends Annotation> {
        final A annotation;
        final Class paramType;

        abstract TransformGenerator get(Annotation[] var1);

        TransformGeneratorRef(A annotation, Class paramType) {
            this.annotation = annotation;
            this.paramType = paramType;
        }

        public String toString() {
            return this.annotation.toString();
        }
    }
}

