/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.util;

import com.maxifier.mxcache.asm.ClassReader;
import com.maxifier.mxcache.asm.ClassVisitor;
import com.maxifier.mxcache.asm.MethodVisitor;
import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.util.CodegenHelper;
import com.maxifier.mxcache.util.MxConstructorGenerator;
import com.maxifier.mxcache.util.MxField;
import com.maxifier.mxcache.util.MxGeneratorAdapter;
import com.maxifier.mxcache.util.SmartClassWriter;

public class ClassGenerator
extends ClassVisitor {
    private static final int DEFAULT_VERSION = 49;
    private Type superType;
    private Type thisType;
    private boolean endVisited;

    public ClassGenerator(int flags) {
        super(262144, (ClassVisitor)new SmartClassWriter(flags));
    }

    public ClassGenerator(ClassReader classReader, int flags) {
        super(262144, (ClassVisitor)new SmartClassWriter(classReader, flags));
    }

    public ClassGenerator(int access, String name, Class superType, Class ... interfaces) {
        this(access, name, superType == null ? null : Type.getType((Class)superType), interfaces == null || interfaces.length == 0 ? null : CodegenHelper.getTypes(interfaces));
    }

    public ClassGenerator(int access, String name, Type superType, Type ... interfaces) {
        this(49, access, name, superType, interfaces);
    }

    public ClassGenerator(int version, int access, String name, Type superType, Type ... interfaces) {
        this(2);
        String[] interfaceNames;
        this.thisType = Type.getObjectType((String)name);
        this.superType = superType;
        if (interfaces != null && interfaces.length > 0) {
            interfaceNames = new String[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                interfaceNames[i] = interfaces[i].getInternalName();
            }
        } else {
            interfaceNames = null;
        }
        super.visit(version, access, name, null, superType == null ? null : superType.getInternalName(), interfaceNames);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.thisType = Type.getObjectType((String)name);
        this.superType = Type.getObjectType((String)superName);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public Type getThisType() {
        return this.thisType;
    }

    public ClassGenerator defineDefaultConstructor() {
        MxConstructorGenerator ctor = this.defineConstructor(1, new Type[0]);
        ctor.start();
        ctor.loadThis();
        ctor.invokeConstructor(this.superType == null ? CodegenHelper.OBJECT_TYPE : this.superType, CodegenHelper.NO_ARG_CONSTRUCTOR);
        ctor.returnValue();
        ctor.endMethod();
        return this;
    }

    public MxConstructorGenerator defineConstructor(int access, Type ... arguments) {
        Method method = new Method("<init>", Type.VOID_TYPE, arguments);
        MethodVisitor mv = this.visitMethod(access, method.getName(), method.getDescriptor(), null, null);
        return new MxConstructorGenerator(mv, access, method, this.thisType, this.superType);
    }

    public MxGeneratorAdapter defineMethod(int access, String name, Type returnType, Type ... arguments) {
        return this.defineMethod(access, new Method(name, returnType, arguments));
    }

    public MxGeneratorAdapter defineMethod(int access, Method method) {
        MethodVisitor mv = this.visitMethod(access, method.getName(), method.getDescriptor(), null, null);
        return new MxGeneratorAdapter(mv, access, method, this.thisType);
    }

    public MxField defineField(int access, String name, Type type) {
        this.visitField(access, name, type.getDescriptor(), null, null);
        return new MxField(access, this.thisType, name, type);
    }

    public <T> Class<T> toClass(ClassLoader classLoader) {
        if (!this.endVisited) {
            this.visitEnd();
        }
        byte[] bytecode = this.toByteArray();
        return CodegenHelper.loadClass(classLoader, bytecode);
    }

    public byte[] toByteArray() {
        return ((SmartClassWriter)this.cv).toByteArray();
    }

    public void visitEnd() {
        this.endVisited = true;
        super.visitEnd();
    }

    public void defineGetter(MxField field, String name) {
        MxGeneratorAdapter mv = this.defineMethod(1, new Method(name, field.getType(), CodegenHelper.EMPTY_TYPES));
        mv.start();
        mv.get(field);
        mv.returnValue();
        mv.endMethod();
    }
}

