/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.util;

import com.maxifier.mxcache.asm.ClassReader;
import com.maxifier.mxcache.asm.ClassVisitor;
import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.asm.util.CheckClassAdapter;
import com.maxifier.mxcache.util.NameFindVisitor;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public final class CodegenHelper {
    public static final Type STRING_TYPE = Type.getType(String.class);
    public static final Type OBJECT_TYPE = Type.getType(Object.class);
    public static final Type CLASS_TYPE = Type.getType(Class.class);
    private static final String CLASS_DUMP_PATH = "C:/dump/";
    private static final java.lang.reflect.Method DEFINE_CLASS_METHOD = CodegenHelper.getDefineClassMethod();
    public static final Type[] EMPTY_TYPES = new Type[0];
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_INITIALIZER_NAME = "<clinit>";
    public static final Method NO_ARG_CONSTRUCTOR = Method.getMethod((String)"void <init>()");
    public static final int STATIC_INITIALIZER_ACCESS = 4106;
    private static final Class[] CLASS_BY_SORT = CodegenHelper.createClassBySortArray();
    private static final Map<Class, Class> BOXING_TYPES = CodegenHelper.createBoxingTypesMap();

    private static Map<Class, Class> createBoxingTypesMap() {
        THashMap res = new THashMap();
        res.put(Boolean.TYPE, Boolean.class);
        res.put(Byte.TYPE, Byte.class);
        res.put(Short.TYPE, Short.class);
        res.put(Character.TYPE, Character.class);
        res.put(Integer.TYPE, Integer.class);
        res.put(Long.TYPE, Long.class);
        res.put(Float.TYPE, Float.class);
        res.put(Double.TYPE, Double.class);
        return res;
    }

    private static java.lang.reflect.Method getDefineClassMethod() {
        return AccessController.doPrivileged(new PrivilegedAction<java.lang.reflect.Method>(){

            @Override
            public java.lang.reflect.Method run() {
                try {
                    java.lang.reflect.Method res = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                    res.setAccessible(true);
                    return res;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot find define class method", e);
                }
            }
        });
    }

    private static Class[] createClassBySortArray() {
        Class[] res = new Class[9];
        res[0] = Void.TYPE;
        res[1] = Boolean.TYPE;
        res[2] = Character.TYPE;
        res[3] = Byte.TYPE;
        res[4] = Short.TYPE;
        res[2] = Character.TYPE;
        res[5] = Integer.TYPE;
        res[6] = Float.TYPE;
        res[7] = Long.TYPE;
        res[8] = Double.TYPE;
        return res;
    }

    private CodegenHelper() {
    }

    @Deprecated
    public static void verify(byte[] bytecode) {
        CheckClassAdapter.verify((ClassReader)new ClassReader(bytecode), (boolean)true, (PrintWriter)new PrintWriter(System.out));
    }

    @Deprecated
    public static void verify(byte[] bytecode, ClassLoader loader) {
        CheckClassAdapter.verify((ClassReader)new ClassReader(bytecode), (ClassLoader)loader, (boolean)true, (PrintWriter)new PrintWriter(System.out));
    }

    @Deprecated
    public static void dumpClass(byte[] bytecode) {
        String className = CodegenHelper.getClassName(bytecode);
        CodegenHelper.dumpClass(className, bytecode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpClass(String className, byte[] bytecode) {
        try {
            String fileName = className.replace('/', '.') + ".class";
            FileOutputStream fos = new FileOutputStream(new File(CLASS_DUMP_PATH, fileName));
            try {
                fos.write(bytecode);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getClassName(byte[] bytecode) {
        ClassReader r = new ClassReader(bytecode);
        NameFindVisitor v = new NameFindVisitor();
        r.accept((ClassVisitor)v, 0);
        return v.getName();
    }

    public static <T> Class<T> loadClass(ClassLoader classLoader, byte[] bytecode) {
        try {
            return (Class)DEFINE_CLASS_METHOD.invoke((Object)classLoader, null, bytecode, 0, bytecode.length);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static java.lang.reflect.Method getMethod(Class owner, String name, String desc) {
        try {
            Type[] types = Type.getArgumentTypes((String)desc);
            Class[] args = CodegenHelper.toClass(owner.getClassLoader(), types);
            return owner.getDeclaredMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Class[] toClass(ClassLoader classLoader, Type[] types) {
        Class[] args = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            args[i] = CodegenHelper.toClass(classLoader, types[i]);
        }
        return args;
    }

    public static Class<?> toClass(ClassLoader classLoader, Type type) {
        Class res;
        int sort = type.getSort();
        if (sort == 9) {
            try {
                return Class.forName(CodegenHelper.getBinaryName(type), true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (sort == 10) {
            try {
                return Class.forName(type.getClassName(), true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (sort >= 0 && sort < CLASS_BY_SORT.length && (res = CLASS_BY_SORT[sort]) != null) {
            return res;
        }
        throw new UnsupportedOperationException("Unknown type: " + type);
    }

    private static String getBinaryName(Type type) {
        return type.getDescriptor().replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteCode(Class c) throws IOException {
        InputStream stream = c.getClassLoader().getResourceAsStream(Type.getType((Class)c).getInternalName() + ".class");
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        finally {
            stream.close();
        }
    }

    public static Class erase(Class type) {
        return type.isPrimitive() ? type : Object.class;
    }

    public static Class[] erase(Class[] types) {
        Class[] res = new Class[types.length];
        int typesLength = types.length;
        for (int i = 0; i < typesLength; ++i) {
            res[i] = CodegenHelper.erase(types[i]);
        }
        return res;
    }

    public static Type erase(Type value) {
        if (value == null) {
            return null;
        }
        return CodegenHelper.isReferenceType(value) ? OBJECT_TYPE : value;
    }

    public static Type[] getTypes(Class[] classes) {
        Type[] types = new Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types[i] = Type.getType((Class)classes[i]);
        }
        return types;
    }

    public static Class[] getClasses(ClassLoader classLoader, Type[] types) {
        Class[] classes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            classes[i] = CodegenHelper.toClass(classLoader, types[i]);
        }
        return classes;
    }

    public static Type[] erase(Type[] values) {
        Type[] types = new Type[values.length];
        for (int i = 0; i < values.length; ++i) {
            types[i] = CodegenHelper.erase(values[i]);
        }
        return types;
    }

    public static Type[] toErasedTypes(Class[] values) {
        Type[] types = new Type[values.length];
        for (int i = 0; i < values.length; ++i) {
            types[i] = CodegenHelper.erase(Type.getType((Class)values[i]));
        }
        return types;
    }

    public static boolean isReferenceType(Type cacheKeyType) {
        int sort = cacheKeyType.getSort();
        return sort == 9 || sort == 10;
    }

    public static Type[] insertFirst(Type[] arguments, Type first) {
        Type[] ctorArguments = new Type[arguments.length + 1];
        ctorArguments[0] = first;
        System.arraycopy(arguments, 0, ctorArguments, 1, arguments.length);
        return ctorArguments;
    }

    public static Class getBoxedType(Class t) {
        return BOXING_TYPES.get(t);
    }
}

