/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.util;

import com.maxifier.mxcache.asm.MethodVisitor;
import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.util.CodegenHelper;
import com.maxifier.mxcache.util.MxField;
import com.maxifier.mxcache.util.MxGeneratorAdapter;

public class MxConstructorGenerator
extends MxGeneratorAdapter {
    private final Type superType;
    private boolean codeVisited;
    private boolean superCalled;
    private int startLocal;

    public MxConstructorGenerator(MethodVisitor mv, int access, Method method, Type thisClass, Type superType) {
        super(mv, access, method, thisClass);
        this.superType = superType;
    }

    public void visitCode() {
        this.codeVisited = true;
        super.visitCode();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 183 && owner.equals(this.superType.getInternalName()) && name.equals("<init>")) {
            this.checkSuperCalled();
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    private void checkSuperCalled() {
        if (this.superCalled) {
            throw new IllegalArgumentException("Super already called");
        }
        this.superCalled = true;
    }

    public void callSuper() {
        this.checkCodeVisited();
        this.loadThis();
        this.invokeConstructor(this.superType, CodegenHelper.NO_ARG_CONSTRUCTOR);
    }

    public void callSuper(Type ... argumentTypes) {
        this.checkCodeVisited();
        this.loadThis();
        for (int i = argumentTypes.length; i != 0; --i) {
            this.loadArg(this.startLocal++);
        }
        this.invokeConstructor(this.superType, new Method("<init>", Type.VOID_TYPE, argumentTypes));
    }

    private void checkCodeVisited() {
        if (!this.codeVisited) {
            this.visitCode();
        }
    }

    public void initFields(MxField ... fields) {
        this.checkCodeVisited();
        for (MxField field : fields) {
            this.loadThis();
            this.loadArg(this.startLocal++);
            this.put(field);
        }
    }
}

