/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.util;

import com.maxifier.mxcache.asm.ClassVisitor;
import com.maxifier.mxcache.asm.MethodVisitor;
import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.GeneratorAdapter;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.util.CodegenHelper;
import com.maxifier.mxcache.util.MxField;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Modifier;
import java.util.Collection;

public class MxGeneratorAdapter
extends GeneratorAdapter {
    public static final Method TO_STRING_METHOD = Method.getMethod((String)"java.lang.String toString()");
    private final Type thisClass;
    private final boolean isStatic;

    public void push(TIntArrayList list) {
        this.push(list.size());
        this.newArray(Type.INT_TYPE);
        for (int i = 0; i < list.size(); ++i) {
            this.dup();
            this.push(i);
            this.push(list.get(i));
            this.arrayStore(Type.INT_TYPE);
        }
    }

    public void push(Collection<String> c) {
        this.push(c.size());
        this.newArray(CodegenHelper.STRING_TYPE);
        int i = 0;
        for (String s : c) {
            this.dup();
            this.push(i++);
            this.push(s);
            this.arrayStore(CodegenHelper.STRING_TYPE);
        }
    }

    public MxGeneratorAdapter(int access, Method method, Type thisClass, ClassVisitor cv) {
        super(262144, cv.visitMethod(access, method.getName(), method.getDescriptor(), null, null), access, method.getName(), method.getDescriptor());
        this.thisClass = thisClass;
        this.isStatic = Modifier.isStatic(access);
    }

    public MxGeneratorAdapter(int access, Method method, MethodVisitor mv, Type thisClass) {
        super(262144, mv, access, method.getName(), method.getDescriptor());
        this.thisClass = thisClass;
        this.isStatic = Modifier.isStatic(access);
    }

    public MxGeneratorAdapter(MethodVisitor mv, int access, Method method, Type thisClass) {
        super(262144, mv, access, method.getName(), method.getDescriptor());
        this.thisClass = thisClass;
        this.isStatic = Modifier.isStatic(access);
    }

    public MxGeneratorAdapter(MethodVisitor mv, int access, String name, String desc, Type thisClass) {
        super(262144, mv, access, name, desc);
        this.thisClass = thisClass;
        this.isStatic = Modifier.isStatic(access);
    }

    public void get(MxField field) {
        if (!field.getOwner().equals((Object)this.thisClass)) {
            throw new IllegalArgumentException("Cannot get field of another class");
        }
        if (this.isStatic && !field.isStatic()) {
            throw new IllegalArgumentException("Cannot access non-static field from static context");
        }
        if (field.isStatic()) {
            this.getStatic(this.thisClass, field.getName(), field.getType());
        } else {
            this.loadThis();
            this.getField(this.thisClass, field.getName(), field.getType());
        }
    }

    public void get(String field, Type type) {
        if (this.isStatic) {
            this.getStatic(this.thisClass, field, type);
        } else {
            this.loadThis();
            this.getField(this.thisClass, field, type);
        }
    }

    public void put(MxField field) {
        if (!field.getOwner().equals((Object)this.thisClass)) {
            throw new IllegalArgumentException("Cannot get field of another class");
        }
        if (this.isStatic && !Modifier.isStatic(field.getAccess())) {
            throw new IllegalArgumentException("Cannot access non-static field from static context");
        }
        this.put(field.getName(), field.getType());
    }

    public void put(String field, Type type) {
        if (this.isStatic) {
            this.putStatic(this.thisClass, field, type);
        } else {
            this.putField(this.thisClass, field, type);
        }
    }

    public void pushNull() {
        this.visitInsn(1);
    }

    public void dup(Type t) {
        this.visitInsn(t.getSize() == 2 ? 92 : 89);
    }

    public void pop(Type t) {
        this.visitInsn(t.getSize() == 2 ? 88 : 87);
    }

    public void start() {
        this.visitCode();
    }

    public void createWithDefaultConstructor(Type t) {
        this.newInstance(t);
        this.dup();
        this.invokeConstructor(t, CodegenHelper.NO_ARG_CONSTRUCTOR);
    }

    public void invokeToString() {
        this.invokeVirtual(CodegenHelper.OBJECT_TYPE, TO_STRING_METHOD);
    }
}

