/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache;

import com.maxifier.mxcache.ContextResolver;
import com.maxifier.mxcache.DefaultCacheContext;
import com.maxifier.mxcache.GenericContextResolver;
import com.maxifier.mxcache.InstanceProvider;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.caches.Calculable;
import com.maxifier.mxcache.clean.CacheCleaner;
import com.maxifier.mxcache.clean.ClassCacheIds;
import com.maxifier.mxcache.clean.Cleanable;
import com.maxifier.mxcache.clean.CleanableRegister;
import com.maxifier.mxcache.config.MxCacheConfigProvider;
import com.maxifier.mxcache.config.MxCacheConfigProviderImpl;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.impl.CacheProviderImpl;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.CacheProvider;
import com.maxifier.mxcache.scheduler.MxScheduler;
import com.maxifier.mxcache.scheduler.MxSchedulerImpl;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CacheFactory {
    private static final CacheProvider PROVIDER = new CacheProviderImpl();
    private static final CleanableRegister REGISTRY = new CleanableRegister();
    private static final MxCacheConfigProvider CONFIGURATION = new MxCacheConfigProviderImpl(true);
    private static final ContextResolver<Object> RESOLVER = new GenericContextResolver();
    private static final MxScheduler SCHEDULER = new MxSchedulerImpl();
    private static final CacheContext DEFAULT_CONTEXT = new DefaultCacheContext();
    private static CacheContext overrideDefault = null;
    private static final ThreadLocal<CacheProvider> PROVIDER_OVERRIDE = new ThreadLocal();

    private CacheFactory() {
    }

    @Deprecated
    public static synchronized InstanceProvider getInstanceProvider() {
        return CacheFactory.getDefaultContext().getInstanceProvider();
    }

    public static CacheCleaner getCleaner() {
        return REGISTRY;
    }

    public static DependencyNode getClassDependencyNode(Class<?> clazz) {
        return REGISTRY.getClassDependencyNode(clazz);
    }

    public static DependencyNode getClassInstanceDependencyNode(Class<?> clazz) {
        return REGISTRY.getClassInstanceDependencyNode(clazz);
    }

    public static DependencyNode getTagDependencyNode(String tag) {
        return REGISTRY.getTagDependencyNode(tag);
    }

    public static DependencyNode getGroupDependencyNode(String group) {
        return REGISTRY.getGroupDependencyNode(group);
    }

    public static <T> void registerClass(Class<T> c, Cleanable<T> cleanable, @Nullable Map<String, ClassCacheIds> groups, @Nullable Map<String, ClassCacheIds> tags) {
        REGISTRY.registerClass(c, cleanable, groups, tags);
    }

    public static void registerInstance(Object o, Class c) {
        REGISTRY.registerInstance(o, c);
    }

    public static List<Cache> getCaches(@Nonnull CacheDescriptor descriptor) {
        return REGISTRY.getCaches(descriptor);
    }

    public static void registerCache(Class<?> c, int id, Class key, Class value, String group, String[] tags, Object calculable, String methodName, String methodDesc) {
        CacheFactory.getProvider().registerCache(c, id, key, value, group, tags, (Calculable)calculable, methodName, methodDesc, null);
    }

    public static void registerCache(Class<?> c, int id, Class key, Class value, String group, String[] tags, Object calculable, String methodName, String methodDesc, String cacheName) {
        CacheFactory.getProvider().registerCache(c, id, key, value, group, tags, (Calculable)calculable, methodName, methodDesc, cacheName);
    }

    @Deprecated
    public static Object createCache(@Nonnull Class caller, int id, Object instance) {
        return CacheFactory.getProvider().createCache(caller, id, instance, CacheFactory.getDefaultContext());
    }

    public static Object createCache(@Nonnull Class caller, int id, Object instance, CacheContext context) {
        return CacheFactory.getProvider().createCache(caller, id, instance, context);
    }

    public static CacheProvider getProvider() {
        CacheProvider override = PROVIDER_OVERRIDE.get();
        if (override != null) {
            return override;
        }
        return PROVIDER;
    }

    public static void setProviderOverride(CacheProvider providerOverride) {
        PROVIDER_OVERRIDE.set(providerOverride);
    }

    public static CacheContext getContext(Object stream) {
        return RESOLVER.getContext(stream);
    }

    public static MxCacheConfigProvider getConfiguration() {
        return CONFIGURATION;
    }

    @Nonnull
    public static CacheContext getDefaultContext() {
        return overrideDefault == null ? DEFAULT_CONTEXT : overrideDefault;
    }

    public static void setDefaultContext(CacheContext defaultContext) {
        overrideDefault = defaultContext;
    }

    public static MxScheduler getScheduler() {
        return SCHEDULER;
    }
}

