/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache;

import com.maxifier.mxcache.CallableWithoutExceptions;
import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.impl.resource.AbstractDependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;

public class DependencyTrackingAction {
    private final DependencyNode dependencyNode = new DependencyNodeImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T trackDependencies(Callable<T> callable) throws Exception {
        while (true) {
            DependencyNode oldNode = null;
            try {
                oldNode = DependencyTracker.track(this.dependencyNode);
                try {
                    T t = callable.call();
                    return t;
                }
                finally {
                    DependencyTracker.exit(oldNode);
                }
            }
            catch (ResourceOccupied e) {
                if (oldNode != null) {
                    throw e;
                }
                e.getResource().waitForEndOfModification();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T trackDependencies(CallableWithoutExceptions<T> callable) {
        while (true) {
            DependencyNode oldNode = null;
            try {
                oldNode = DependencyTracker.track(this.dependencyNode);
                try {
                    T t = callable.call();
                    return t;
                }
                finally {
                    DependencyTracker.exit(oldNode);
                }
            }
            catch (ResourceOccupied e) {
                if (oldNode != null) {
                    throw e;
                }
                e.getResource().waitForEndOfModification();
                continue;
            }
            break;
        }
    }

    public void trackDependencies(Runnable callable) {
        while (true) {
            DependencyNode oldNode = null;
            try {
                oldNode = DependencyTracker.track(this.dependencyNode);
                try {
                    callable.run();
                    return;
                }
                finally {
                    DependencyTracker.exit(oldNode);
                }
            }
            catch (ResourceOccupied e) {
                if (oldNode != null) {
                    throw e;
                }
                e.getResource().waitForEndOfModification();
                continue;
            }
            break;
        }
    }

    public void mark() {
        DependencyTracker.mark(this.dependencyNode);
    }

    protected void onClear() {
    }

    private class DependencyNodeImpl
    extends AbstractDependencyNode {
        private DependencyNodeImpl() {
        }

        @Override
        public void addNode(@Nonnull CleaningNode cache) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void invalidate() {
            DependencyTrackingAction.this.onClear();
        }
    }
}

