/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.ContextResolver;
import com.maxifier.mxcache.context.CacheContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;

class GenericContextResolver
implements ContextResolver<Object> {
    private final Map<Class, Collection<ContextResolver>> resolverMapping = new THashMap();

    public GenericContextResolver(Iterable<ContextResolver> resolvers) {
        for (ContextResolver resolver : resolvers) {
            Class streamClass = resolver.getContextOwnerClass();
            Collection<ContextResolver> list = this.resolverMapping.get(streamClass);
            if (list == null) {
                this.resolverMapping.put(streamClass, Collections.singleton(resolver));
                continue;
            }
            if (list.size() == 1) {
                list = new ArrayList<ContextResolver>(list);
                this.resolverMapping.put(streamClass, list);
            }
            list.add(resolver);
        }
    }

    public GenericContextResolver() {
        this(ServiceLoader.load(ContextResolver.class));
    }

    @Override
    public Class<Object> getContextOwnerClass() {
        return Object.class;
    }

    @Override
    public CacheContext getContext(Object owner) {
        Class<?> cls = owner.getClass();
        for (ContextResolver resolver : this.getResolvers(cls)) {
            CacheContext res = resolver.getContext(owner);
            if (res == null) continue;
            return res;
        }
        return CacheFactory.getDefaultContext();
    }

    private synchronized Collection<ContextResolver> getResolvers(Class<?> streamClass) {
        Collection<ContextResolver> res = this.resolverMapping.get(streamClass);
        if (res != null) {
            return res;
        }
        res = this.createResolvers(streamClass);
        this.resolverMapping.put(streamClass, res);
        return res;
    }

    private Collection<ContextResolver> createResolvers(Class<?> streamClass) {
        THashSet res = new THashSet();
        Class<?> superclass = streamClass.getSuperclass();
        if (superclass != null) {
            res.addAll(this.getResolvers(superclass));
        }
        for (Class<?> intf : streamClass.getInterfaces()) {
            res.addAll(this.getResolvers(intf));
        }
        if (res.isEmpty()) {
            return Collections.emptyList();
        }
        if (res.size() == 1) {
            return Collections.singleton(res.iterator().next());
        }
        return res;
    }
}

