/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;

public class LightweightLock
extends AbstractQueuedSynchronizer
implements Lock {
    private static final long serialVersionUID = 1L;

    @Override
    protected boolean tryAcquire(int acquires) {
        Thread current = Thread.currentThread();
        int c = this.getState();
        if (c == 0) {
            if (this.compareAndSetState(0, acquires)) {
                this.setExclusiveOwnerThread(current);
                return true;
            }
        } else if (current == this.getExclusiveOwnerThread()) {
            if ((c += acquires) < 0) {
                throw new Error("Maximum lock count exceeded");
            }
            this.setState(c);
            return true;
        }
        return false;
    }

    @Override
    protected final boolean tryRelease(int releases) {
        int c = this.getState() - releases;
        if (Thread.currentThread() != this.getExclusiveOwnerThread()) {
            throw new IllegalMonitorStateException();
        }
        if (c == 0) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }
        this.setState(c);
        return false;
    }

    @Override
    protected final boolean isHeldExclusively() {
        return Thread.currentThread() == this.getExclusiveOwnerThread();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setState(0);
    }

    @Override
    @Nonnull
    public final AbstractQueuedSynchronizer.ConditionObject newCondition() {
        return new AbstractQueuedSynchronizer.ConditionObject(this);
    }

    @Override
    public final void lock() {
        if (this.compareAndSetState(0, 1)) {
            this.setExclusiveOwnerThread(Thread.currentThread());
        } else {
            this.acquire(1);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryLock(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.tryAcquireNanos(1, unit.toNanos(timeout));
    }

    @Override
    public void unlock() {
        this.release(1);
    }

    public boolean isHeldByCurrentThread() {
        return super.getExclusiveOwnerThread() == Thread.currentThread();
    }
}

