/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache;

public class Version
implements Comparable<Version> {
    public static final Version UNKNOWN = new Version("UNKNOWN");
    private final String text;

    public Version(String text) {
        this.text = text;
    }

    @Override
    public int compareTo(Version o) {
        if (this == o) {
            return 0;
        }
        String t1 = this.text;
        String t2 = o.text;
        int p1 = 0;
        int p2 = 0;
        int n1 = t1.length();
        int n2 = t2.length();
        while (true) {
            if (p1 == n1) {
                if (p2 == n2) {
                    return 0;
                }
                return 1;
            }
            if (p2 == n2) {
                return -1;
            }
            char c1 = t1.charAt(p1);
            char c2 = t2.charAt(p2);
            if (Character.isDigit(c1) && Character.isDigit(c2)) {
                long v2;
                int e1 = Version.findNumberEnd(t1, p1);
                int e2 = Version.findNumberEnd(t2, p2);
                long v1 = Long.valueOf(t1.substring(p1, e1));
                if (v1 < (v2 = Long.valueOf(t2.substring(p2, e2)).longValue())) {
                    return -1;
                }
                if (v1 > v2) {
                    return 1;
                }
                p1 = e1;
                p2 = e2;
                continue;
            }
            if (c1 < c2) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            ++p1;
            ++p2;
        }
    }

    private static int findNumberEnd(String text, int pos) {
        int n = text.length();
        while (pos < n && Character.isDigit(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.text.equals(version.text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public String toString() {
        return this.text;
    }
}

