/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.clean;

import com.maxifier.mxcache.Cached;
import com.maxifier.mxcache.NonInstrumentedCacheException;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.clean.CacheCleaner;
import com.maxifier.mxcache.clean.ClassCacheIds;
import com.maxifier.mxcache.clean.ClassCleanableInstanceList;
import com.maxifier.mxcache.clean.Cleanable;
import com.maxifier.mxcache.impl.resource.AbstractDependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.provider.CacheDescriptor;
import gnu.trove.map.hash.THashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CleanableRegister
implements CacheCleaner {
    private static final Logger logger = LoggerFactory.getLogger(CleanableRegister.class);
    private final Map<Class<?>, ClassCleanableInstanceList<?>> classCleanMap = new THashMap();
    private final Map<Class<?>, DependencyNode> classStaticNodes = new THashMap();
    private final Map<Class<?>, DependencyNode> classInstanceNodes = new THashMap();
    private final Map<String, DependencyNode> groupNodes = new THashMap();
    private final Map<String, DependencyNode> tagNodes = new THashMap();
    private static final Cleanable<?> EMPTY_CLEANABLE = new EmptyCleanable();

    public synchronized <T> void registerClass(Class<T> clazz, Cleanable<T> cleanable, @Nullable Map<String, ClassCacheIds> groups, @Nullable Map<String, ClassCacheIds> tags) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Interface could not have cached methods!");
        }
        ClassCleanableInstanceList<Object> superClassList = this.getClassList(clazz.getSuperclass());
        ClassCleanableInstanceList<Object> instanceList = new ClassCleanableInstanceList<Object>(superClassList, cleanable, groups, tags, clazz);
        ClassCleanableInstanceList<Object> oldValue = this.classCleanMap.put(clazz, instanceList);
        if (oldValue != null) {
            throw new IllegalStateException(clazz + " already registered");
        }
    }

    private synchronized ClassCleanableInstanceList<Object> getClassList(Class cls) {
        if (cls == Object.class) {
            return null;
        }
        assert (!cls.isInterface());
        ClassCleanableInstanceList<Object> list = this.classCleanMap.get(cls);
        if (list == null) {
            list = new ClassCleanableInstanceList<Object>(this.getClassList(cls.getSuperclass()), EMPTY_CLEANABLE, null, null, cls);
            this.classCleanMap.put(cls, list);
        }
        return list;
    }

    public void registerInstance(Object o, Class<?> aClass) {
        ClassCleanableInstanceList<?> instanceList = this.getListByClass(aClass);
        if (instanceList == null) {
            throw new IllegalArgumentException(String.format("Object %s has no cache", o));
        }
        instanceList.add(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cache> getCaches(@Nonnull CacheDescriptor descriptor) {
        ClassCleanableInstanceList<?> list = this.getListByClass(descriptor.getDeclaringClass());
        if (list == null) {
            logger.error("Unknown class required: " + descriptor.getDeclaringClass());
            return Collections.emptyList();
        }
        Cleanable<?> cleanable = list.getCleanable();
        if (descriptor.isStatic()) {
            return Collections.singletonList(cleanable.getStaticCache(descriptor.getId()));
        }
        list.lock();
        try {
            if (list.isEmpty()) {
                List<Cache> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<Cache> instances = new ArrayList<Cache>(list.size());
            for (Object instance : list) {
                instances.add(cleanable.getInstanceCache(instance, descriptor.getId()));
            }
            ArrayList<Cache> arrayList = instances;
            return arrayList;
        }
        finally {
            list.unlock();
        }
    }

    private synchronized ClassCleanableInstanceList<?> getListByClass(Class<?> aClass) {
        return this.classCleanMap.get(aClass);
    }

    @Override
    public void clearCacheByInstances(Object ... o) {
        for (Object object : o) {
            this.clearCacheByInstance(object);
        }
    }

    @Override
    public void clearCacheByInstance(Object o) {
        for (Class<?> aClass = o.getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            ClassCleanableInstanceList<?> cleanableInstanceList = this.getListByClass(aClass);
            if (cleanableInstanceList == null) {
                continue;
            }
            cleanableInstanceList.clearCache(o);
            return;
        }
        CleanableRegister.checkNonInstrumentedCaches(o.getClass());
        throw new IllegalArgumentException(String.format("Object %s has no caches", o));
    }

    static void checkNonInstrumentedCaches(Class c) throws NonInstrumentedCacheException {
        while (c != null && c != Object.class) {
            for (Method m : c.getDeclaredMethods()) {
                if (m.getAnnotation(Cached.class) == null) continue;
                throw new NonInstrumentedCacheException(m);
            }
            c = c.getSuperclass();
        }
    }

    @Override
    public void clearInstanceByTag(Object o, String tag) {
        for (Class<?> aClass = o.getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            ClassCleanableInstanceList<?> cleanableInstanceList = this.getListByClass(aClass);
            if (cleanableInstanceList == null) {
                continue;
            }
            cleanableInstanceList.clearCacheByTag(o, tag);
            return;
        }
        CleanableRegister.checkNonInstrumentedCaches(o.getClass());
        throw new IllegalArgumentException(String.format("Object %s has no caches", o));
    }

    @Override
    public void clearInstanceByGroup(Object o, String group) {
        for (Class<?> aClass = o.getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            ClassCleanableInstanceList<?> cleanableInstanceList = this.getListByClass(aClass);
            if (cleanableInstanceList == null) {
                continue;
            }
            cleanableInstanceList.clearCacheByGroup(o, group);
            return;
        }
        CleanableRegister.checkNonInstrumentedCaches(o.getClass());
        throw new IllegalArgumentException(String.format("Object %s has no caches", o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCacheByClass(Class<?> clazz) {
        DependencyNode node;
        CleanableRegister.checkNonInstrumentedCaches(clazz);
        CleanableRegister cleanableRegister = this;
        synchronized (cleanableRegister) {
            node = this.classStaticNodes.get(clazz);
        }
        if (node == null) {
            logger.warn("There is no subclasses of " + clazz + " with caches yet");
        } else {
            DependencyTracker.deepInvalidate(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCacheByGroup(String group) {
        DependencyNode node;
        CleanableRegister cleanableRegister = this;
        synchronized (cleanableRegister) {
            node = this.groupNodes.get(group);
        }
        if (node == null) {
            logger.warn("There is no caches of group <" + group + "> yet");
        } else {
            DependencyTracker.deepInvalidate(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCacheByTag(String tag) {
        DependencyNode node;
        CleanableRegister cleanableRegister = this;
        synchronized (cleanableRegister) {
            node = this.tagNodes.get(tag);
        }
        if (node == null) {
            logger.warn("There is no caches with tag <" + tag + "> yet");
        } else {
            DependencyTracker.deepInvalidate(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCacheByAnnotation(Class<? extends Annotation> annotationClass) {
        DependencyNode node;
        CleanableRegister cleanableRegister = this;
        synchronized (cleanableRegister) {
            node = this.tagNodes.get("@" + annotationClass.getName());
        }
        if (node == null) {
            logger.warn("Can`t find cache for annotation " + annotationClass);
        } else {
            DependencyTracker.deepInvalidate(node);
        }
    }

    @Nonnull
    public synchronized DependencyNode getClassDependencyNode(Class<?> clazz) {
        DependencyNode tagNode = this.classStaticNodes.get(clazz);
        if (tagNode == null) {
            tagNode = new EmptyDependencyNode("class:" + clazz.getName());
            this.classStaticNodes.put(clazz, tagNode);
        }
        return tagNode;
    }

    @Nonnull
    public synchronized DependencyNode getClassInstanceDependencyNode(Class<?> clazz) {
        DependencyNode tagNode = this.classInstanceNodes.get(clazz);
        if (tagNode == null) {
            tagNode = new EmptyDependencyNode("instance:" + clazz.getName());
            this.trackParentAndInterfaceDependencies(clazz, tagNode);
            this.classInstanceNodes.put(clazz, tagNode);
        }
        return tagNode;
    }

    private void trackParentAndInterfaceDependencies(Class<?> clazz, DependencyNode tagNode) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.getClassInstanceDependencyNode(superclass).trackDependency(tagNode);
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            this.getClassInstanceDependencyNode(intf).trackDependency(tagNode);
        }
        this.getClassDependencyNode(clazz).trackDependency(tagNode);
    }

    @Nonnull
    public synchronized DependencyNode getTagDependencyNode(String tag) {
        DependencyNode tagNode = this.tagNodes.get(tag);
        if (tagNode == null) {
            tagNode = new EmptyDependencyNode("tag:" + tag);
            this.tagNodes.put(tag, tagNode);
        }
        return tagNode;
    }

    @Nonnull
    public synchronized DependencyNode getGroupDependencyNode(String group) {
        DependencyNode groupNode = this.groupNodes.get(group);
        if (groupNode == null) {
            groupNode = new EmptyDependencyNode("group:" + group);
            this.groupNodes.put(group, groupNode);
        }
        return groupNode;
    }

    private static class EmptyDependencyNode
    extends AbstractDependencyNode {
        private final String name;

        public EmptyDependencyNode(String name) {
            this.name = name;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void addNode(@Nonnull CleaningNode cache) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.name;
        }
    }

    private static class EmptyCleanable
    implements Cleanable<Object> {
        private EmptyCleanable() {
        }

        @Override
        public void appendInstanceCachesTo(List<CleaningNode> locks, Object o) {
        }

        @Override
        public Cache getStaticCache(int id) {
            throw new IllegalArgumentException("Interface has no caches");
        }

        @Override
        public Cache getInstanceCache(Object o, int id) {
            throw new IllegalArgumentException("Interface has no caches");
        }
    }
}

