/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.clean;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MappingIterable<F, T>
implements Iterable<T> {
    private final Iterable<? extends F> iterable;

    protected MappingIterable(@Nonnull Iterable<? extends F> iterable) {
        this.iterable = iterable;
    }

    @Override
    public Iterator<T> iterator() {
        return new MappingIterator(this.iterable.iterator());
    }

    public abstract T map(@Nullable F var1);

    public String toString() {
        return this.iterable.toString();
    }

    private final class MappingIterator
    implements Iterator<T> {
        private final Iterator<? extends F> iterator;
        private T next;

        private MappingIterator(Iterator<? extends F> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null && this.iterator.hasNext()) {
                this.next = MappingIterable.this.map(this.iterator.next());
            }
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object res = this.next;
            this.next = null;
            return res;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

