/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.clean;

import com.maxifier.mxcache.LightweightLock;
import com.maxifier.mxcache.transform.SmartReference;
import com.maxifier.mxcache.transform.SmartReferenceManager;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

class WeakList<T>
implements Iterable<T> {
    private final LightweightLock lock = new LightweightLock();
    private volatile InstanceReference head;
    private volatile int version;
    private volatile int size;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceReference remove(InstanceReference ref) {
        this.lock.lock();
        try {
            --this.size;
            InstanceReference prev = ref.prev;
            InstanceReference next = ref.next;
            if (prev == null) {
                this.head = next;
                if (next != null) {
                    next.prev = null;
                }
            } else {
                prev.next = next;
                if (next != null) {
                    next.prev = prev;
                }
            }
            InstanceReference instanceReference = next;
            return instanceReference;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void add(@Nonnull Object t) {
        this.lock.lock();
        try {
            ++this.version;
            ++this.size;
            InstanceReference ref = new InstanceReference(t);
            ref.next = this.head;
            if (this.head != null) {
                this.head.prev = ref;
            }
            this.head = ref;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int lock() {
        this.lock.lock();
        return this.version;
    }

    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public Iterator<T> iterator() {
        assert (this.lock.isHeldByCurrentThread());
        return new InstanceIterator();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private class InstanceIterator
    implements Iterator<T> {
        private InstanceReference nextReference;
        private T instance;

        private InstanceIterator() {
            this.nextReference = WeakList.this.head;
        }

        @Override
        public boolean hasNext() {
            while (this.nextReference != null && (this.instance = this.nextReference.get()) == null) {
                this.nextReference = WeakList.this.remove(this.nextReference);
            }
            return this.nextReference != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object res = this.instance;
            this.nextReference = this.nextReference.next;
            this.instance = null;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class InstanceReference
    extends WeakReference<T>
    implements SmartReference,
    Runnable {
        private volatile InstanceReference next;
        private volatile InstanceReference prev;

        InstanceReference(T referent) {
            super(referent, SmartReferenceManager.getReferenceQueue());
        }

        @Override
        public Runnable getCallback() {
            return this;
        }

        @Override
        public void setCallback(Runnable callback) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void run() {
            WeakList.this.remove(this);
        }
    }
}

