/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.concurrent;

import com.maxifier.mxcache.concurrent.ConcurrentCache;
import com.maxifier.mxcache.impl.caches.def.TroveHelper;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.StrategyProperty;
import com.maxifier.mxcache.storage.elementlocked.ObjectObjectElementLockedStorage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentObjectObjectStorage<K>
implements ObjectObjectElementLockedStorage<K> {
    private static final float LOAD_FACTOR = 0.75f;
    private final Lock readLock;
    private final Lock writeLock;
    private static final StrategyProperty<Integer> CONCURRENCY_LEVEL = StrategyProperty.create("concurrency-level", Integer.class, 4, ConcurrentCache.class, "concurrencyLevel");
    private static final StrategyProperty<Integer> INITIAL_CAPACITY = StrategyProperty.create("initial-capacity", Integer.class, 16, ConcurrentCache.class, "initialCapacity");
    private final ConcurrentHashMap<K, Object> concurrentHashMap;

    public ConcurrentObjectObjectStorage(CacheDescriptor descriptor) {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.concurrentHashMap = new ConcurrentHashMap(descriptor.getProperty(INITIAL_CAPACITY), 0.75f, descriptor.getProperty(CONCURRENCY_LEVEL));
    }

    @Override
    public void lock(K key) {
        this.readLock.lock();
    }

    @Override
    public void unlock(K key) {
        this.readLock.unlock();
    }

    @Override
    public Lock getLock() {
        return this.writeLock;
    }

    @Override
    public void clear() {
        this.concurrentHashMap.clear();
    }

    @Override
    public int size() {
        return this.concurrentHashMap.size();
    }

    @Override
    public Object load(K o) {
        Object res = this.concurrentHashMap.get(o);
        if (res == null) {
            return UNDEFINED;
        }
        return res == TroveHelper.NULL_REPLACEMENT ? null : res;
    }

    @Override
    public void save(K o, Object v) {
        this.concurrentHashMap.put(o, v == null ? TroveHelper.NULL_REPLACEMENT : v);
    }
}

