/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.config;

import com.maxifier.mxcache.config.ConfigurationControl;
import com.maxifier.mxcache.config.JaxbRule;
import com.maxifier.mxcache.config.MxCacheConfig;
import com.maxifier.mxcache.config.MxCacheConfigProvider;
import com.maxifier.mxcache.config.ResourceConfig;
import com.maxifier.mxcache.config.Rule;
import com.maxifier.mxcache.config.RuleWithSelector;
import com.maxifier.mxcache.impl.CacheProviderImpl;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MxCacheConfigProviderImpl
implements MxCacheConfigProvider {
    private static final Logger logger = LoggerFactory.getLogger(MxCacheConfigProviderImpl.class);
    private final Map<ClassLoader, MxCacheConfig> configs = new WeakHashMap<ClassLoader, MxCacheConfig>();

    public MxCacheConfigProviderImpl(boolean needsMBean) {
        if (needsMBean) {
            CacheProviderImpl.registerMBean(new ConfigurationControl(this), "com.maxifier.mxcache:service=ConfigurationControl");
        }
    }

    @Override
    public Rule getRule(Class cls, String group, String[] tags) {
        JaxbRule result = new JaxbRule();
        for (RuleWithSelector rule : this.getConfig(cls.getClassLoader()).getRules()) {
            if (!rule.matches(cls, group, tags)) continue;
            result.addRuleName(rule.getName());
            result.override(rule);
        }
        return result;
    }

    @Override
    public List<ResourceConfig> getResources() {
        return this.getConfig(null).getResources();
    }

    public List<RuleWithSelector> getRules() {
        LinkedHashSet<RuleWithSelector> res = new LinkedHashSet<RuleWithSelector>();
        for (MxCacheConfig config : this.configs.values()) {
            res.addAll(config.getRules());
        }
        return new ArrayList<RuleWithSelector>(res);
    }

    MxCacheConfig loadBootstrapConfig() {
        MxCacheConfig config = new MxCacheConfig();
        try {
            File f;
            String url;
            JAXBContext context = MxCacheConfigProviderImpl.getJAXBContext();
            Enumeration<URL> configs = ClassLoader.getSystemResources("META-INF/mxcache.xml");
            while (configs.hasMoreElements()) {
                MxCacheConfigProviderImpl.overrideFrom(config, context, configs.nextElement());
            }
            String path = System.getProperty("mxcache.xml.path");
            if (path != null) {
                MxCacheConfigProviderImpl.overrideFrom(config, context, new File(path));
            }
            if ((url = System.getProperty("mxcache.xml.url")) != null) {
                MxCacheConfigProviderImpl.overrideFrom(config, context, new URL(url));
            }
            if ((f = new File("mxcache.xml")).exists()) {
                MxCacheConfigProviderImpl.overrideFrom(config, context, f);
            }
        }
        catch (Exception e) {
            MxCacheConfigProviderImpl.logLoadingError(e, "unknown");
        }
        return config;
    }

    private MxCacheConfig loadConfig(ClassLoader classLoader) {
        if (classLoader == null) {
            return this.loadBootstrapConfig();
        }
        MxCacheConfig parentConfig = this.getConfig(classLoader.getParent());
        MxCacheConfig config = new MxCacheConfig();
        config.merge(parentConfig);
        try {
            JAXBContext context = MxCacheConfigProviderImpl.getJAXBContext();
            Enumeration<URL> configs = classLoader.getResources("META-INF/mxcache.xml");
            while (configs.hasMoreElements()) {
                URL url = configs.nextElement();
                if (parentConfig.hasSource(url)) continue;
                MxCacheConfigProviderImpl.overrideFrom(config, context, url);
            }
        }
        catch (Exception e) {
            MxCacheConfigProviderImpl.logLoadingError(e, "unknown");
        }
        return config;
    }

    private synchronized MxCacheConfig getConfig(ClassLoader classLoader) {
        MxCacheConfig config = this.configs.get(classLoader);
        if (config == null) {
            config = this.loadConfig(classLoader);
            this.configs.put(classLoader, config);
        }
        return config;
    }

    private static void overrideFrom(MxCacheConfig config, JAXBContext context, File file) {
        try {
            MxCacheConfig newConfig = MxCacheConfigProviderImpl.load(context, file);
            newConfig.setSource(file.toString());
            config.merge(newConfig);
        }
        catch (Exception e) {
            MxCacheConfigProviderImpl.logLoadingError(e, file.toString());
        }
    }

    private static void overrideFrom(MxCacheConfig config, JAXBContext context, URL url) {
        try {
            MxCacheConfig newConfig = MxCacheConfigProviderImpl.load(context, url);
            newConfig.setSource(url.toString());
            config.merge(newConfig);
        }
        catch (Exception e) {
            MxCacheConfigProviderImpl.logLoadingError(e, url.toString());
        }
    }

    private static void logLoadingError(Exception e, String source) {
        logger.error("MxCache configuration loading failed (" + source + ")", (Throwable)e);
    }

    static MxCacheConfig load(JAXBContext context, URL url) throws JAXBException {
        MxCacheConfig res = (MxCacheConfig)context.createUnmarshaller().unmarshal(url);
        res.addSource(url);
        return res;
    }

    static MxCacheConfig load(JAXBContext context, File path) throws JAXBException {
        return (MxCacheConfig)context.createUnmarshaller().unmarshal(path);
    }

    static JAXBContext getJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)MxCacheConfig.class.getPackage().getName());
    }

    public static JaxbRule loadRule(String ... xmlRules) throws JAXBException {
        JAXBContext context = MxCacheConfigProviderImpl.getJAXBContext();
        JaxbRule r = new JaxbRule();
        for (String rule : xmlRules) {
            r.override((JaxbRule)context.createUnmarshaller().unmarshal((Reader)new StringReader(rule)));
        }
        return r;
    }
}

