/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.exceptions;

import com.maxifier.mxcache.CacheExceptionPolicy;

public class CacheExceptionHandler {
    private final CacheExceptionPolicy policy;

    public CacheExceptionHandler(CacheExceptionPolicy policy) {
        this.policy = policy;
    }

    public Action getAction(int retry, Exception e) {
        if (this.policy == null) {
            return Action.RETHROW;
        }
        for (CacheExceptionPolicy.SpecialCase specialCase : this.policy.specialCases()) {
            if (!specialCase.exceptionClass().isAssignableFrom(e.getClass())) continue;
            int retries = specialCase.retries();
            if (retries < 0) {
                retries = this.policy.retries();
            }
            if (retry < retries) {
                long sleep = specialCase.sleepBeforeRetryMillis();
                if (sleep < 0L) {
                    sleep = this.policy.sleepBeforeRetryMillis();
                }
                if (sleep > 0L) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException interrupted) {
                        Thread.interrupted();
                        return Action.RETHROW;
                    }
                }
                return Action.RETRY;
            }
            return specialCase.rememberExceptions() ? Action.REMEMBER_AND_RETHROW : Action.RETHROW;
        }
        if (retry < this.policy.retries()) {
            long sleep = this.policy.sleepBeforeRetryMillis();
            if (sleep > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interrupted) {
                    Thread.interrupted();
                    return Action.RETHROW;
                }
            }
            return Action.RETRY;
        }
        return this.policy.rememberExceptions() ? Action.REMEMBER_AND_RETHROW : Action.RETHROW;
    }

    public long getRememberExceptionExpirationTimestamp(Exception e) {
        long timeout;
        for (CacheExceptionPolicy.SpecialCase specialCase : this.policy.specialCases()) {
            if (!specialCase.exceptionClass().isAssignableFrom(e.getClass())) continue;
            long timeout2 = specialCase.rememberExceptionTimeoutMillis();
            if (timeout2 < 0L) break;
            if (timeout2 == 0L) {
                return 0L;
            }
            return timeout2 + System.currentTimeMillis();
        }
        if ((timeout = this.policy.rememberExceptionTimeoutMillis()) == 0L) {
            return 0L;
        }
        return timeout + System.currentTimeMillis();
    }

    public static enum Action {
        RETRY,
        REMEMBER_AND_RETHROW,
        RETHROW;

    }
}

