/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.hashing;

import com.maxifier.mxcache.hashing.ArrayHashingStrategy;
import com.maxifier.mxcache.hashing.BooleanArrayHashingStrategy;
import com.maxifier.mxcache.hashing.ByteArrayHashingStrategy;
import com.maxifier.mxcache.hashing.CharArrayHashingStrategy;
import com.maxifier.mxcache.hashing.DoubleArrayHashingStrategy;
import com.maxifier.mxcache.hashing.FloatArrayHashingStrategy;
import com.maxifier.mxcache.hashing.IntArrayHashingStrategy;
import com.maxifier.mxcache.hashing.LongArrayHashingStrategy;
import com.maxifier.mxcache.hashing.ShortArrayHashingStrategy;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HashingStrategyFactory {
    private static final Logger logger = LoggerFactory.getLogger(HashingStrategyFactory.class);

    public static HashingStrategy[] createHashingStrategies(Class[] argsTypes, Class<? extends HashingStrategy>[] definedHSForArgs) {
        HashingStrategy[] result = new HashingStrategy[argsTypes.length];
        for (int i = 0; i < result.length; ++i) {
            if (argsTypes[i].isPrimitive()) {
                result[i] = null;
                if (definedHSForArgs[i] == null) continue;
                logger.error("Argument of primitive type cannot have custom hashing strategy " + definedHSForArgs[i] + "");
                continue;
            }
            if (definedHSForArgs[i] != null) {
                if (IdentityHashingStrategy.class.equals(definedHSForArgs[i])) {
                    result[i] = IdentityHashingStrategy.INSTANCE;
                    continue;
                }
                result[i] = HashingStrategyFactory.tryDefaultConstructor(definedHSForArgs[i]);
                if (result[i] != null) continue;
                logger.error("Can't instantiate custom HashingStrategy class " + definedHSForArgs[i] + ", will use default strategy");
                if (!argsTypes[i].isArray()) continue;
                result[i] = HashingStrategyFactory.getArrayHashingStrategy(argsTypes[i]);
                continue;
            }
            result[i] = argsTypes[i].isArray() ? HashingStrategyFactory.getArrayHashingStrategy(argsTypes[i]) : null;
        }
        return result;
    }

    @Nullable
    private static HashingStrategy tryDefaultConstructor(Class<? extends HashingStrategy> hsClass) {
        try {
            Constructor<? extends HashingStrategy> ctor = hsClass.getConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static HashingStrategy getArrayHashingStrategy(Class paramType) {
        if (paramType == boolean[].class) {
            return BooleanArrayHashingStrategy.getInstance();
        }
        if (paramType == byte[].class) {
            return ByteArrayHashingStrategy.getInstance();
        }
        if (paramType == char[].class) {
            return CharArrayHashingStrategy.getInstance();
        }
        if (paramType == short[].class) {
            return ShortArrayHashingStrategy.getInstance();
        }
        if (paramType == int[].class) {
            return IntArrayHashingStrategy.getInstance();
        }
        if (paramType == long[].class) {
            return LongArrayHashingStrategy.getInstance();
        }
        if (paramType == float[].class) {
            return FloatArrayHashingStrategy.getInstance();
        }
        if (paramType == double[].class) {
            return DoubleArrayHashingStrategy.getInstance();
        }
        if (paramType.isArray()) {
            return ArrayHashingStrategy.getInstance();
        }
        throw new AssertionError();
    }
}

