/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.Signature;
import com.maxifier.mxcache.provider.StorageFactory;
import com.maxifier.mxcache.storage.Storage;
import com.maxifier.mxcache.transform.Ignore;
import com.maxifier.mxcache.transform.SoftKey;
import com.maxifier.mxcache.transform.WeakKey;
import gnu.trove.list.array.TIntArrayList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;

public class DefaultStorageFactory
implements StorageFactory {
    private static final String CACHES_PACKAGE = "com.maxifier.mxcache.impl.caches.def.";
    private final Class implementation;
    private final Constructor<? extends Storage> storageConstructor;
    private final int[] tupleIndices;

    DefaultStorageFactory(CacheDescriptor descriptor) {
        Signature transformedSignature = descriptor.getTransformedSignature().overrideValue(Object.class);
        if (!transformedSignature.hasKeys()) {
            this.implementation = transformedSignature.getImplementationClass(CACHES_PACKAGE, "StorageImpl");
            this.tupleIndices = null;
        } else {
            TIntArrayList p = this.getReferenceKeys(descriptor);
            if (p.isEmpty()) {
                this.implementation = transformedSignature.getImplementationClass(CACHES_PACKAGE, "TroveStorage");
                this.tupleIndices = null;
            } else if (transformedSignature.getKeyCount() == 1) {
                this.implementation = transformedSignature.getImplementationClass(CACHES_PACKAGE, "WeakTroveStorage");
                this.tupleIndices = null;
            } else {
                this.implementation = this.findClass("com.maxifier.mxcache.impl.caches.def.Tuple" + Signature.toString(descriptor.getValueType()) + "WeakTroveStorage");
                this.tupleIndices = p.toArray();
            }
        }
        this.storageConstructor = this.getStorageConstructor();
    }

    private Class findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private Constructor<? extends Storage> getStorageConstructor() {
        int desiredCount = this.tupleIndices == null ? 0 : 1;
        for (Constructor<?> constructor : this.implementation.getConstructors()) {
            if (constructor.getParameterTypes().length != desiredCount) continue;
            return constructor;
        }
        throw new IllegalStateException("No corresponding constructor at " + this.implementation);
    }

    @Override
    @Nonnull
    public Storage createStorage(Object owner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        if (this.tupleIndices == null) {
            return this.storageConstructor.newInstance(new Object[0]);
        }
        return this.storageConstructor.newInstance(new Object[]{this.tupleIndices});
    }

    private TIntArrayList getReferenceKeys(CacheDescriptor descriptor) {
        Annotation[][] ann = descriptor.getMethod().getParameterAnnotations();
        TIntArrayList p = new TIntArrayList(ann.length);
        int pos = 0;
        for (Annotation[] annotations : ann) {
            boolean ref = false;
            boolean ignored = false;
            for (Annotation a : annotations) {
                if (a instanceof WeakKey || a instanceof SoftKey) {
                    ref = true;
                }
                if (!(a instanceof Ignore)) continue;
                ignored = true;
            }
            if (ignored) continue;
            if (ref) {
                p.add(pos);
            }
            ++pos;
        }
        return p;
    }

    @Override
    public String getImplementationDetails() {
        return this.storageConstructor.getDeclaringClass().getCanonicalName();
    }
}

