/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.impl.CustomStorageFactory;
import com.maxifier.mxcache.impl.DefaultStorageFactory;
import com.maxifier.mxcache.impl.StorageBasedCacheManager;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.CacheManager;
import com.maxifier.mxcache.provider.CachingStrategy;
import com.maxifier.mxcache.provider.StorageFactory;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStrategy
implements CachingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStrategy.class);
    private static final String CANNOT_INSTANTIATE_MESSAGE = "Cannot instantiate StorageFactory for %s (%s)";
    private static final DefaultStrategy INSTANCE = new DefaultStrategy();

    public static DefaultStrategy getInstance() {
        return INSTANCE;
    }

    private DefaultStrategy() {
    }

    @Override
    @Nonnull
    public CacheManager getManager(CacheContext context, Class<?> ownerClass, CacheDescriptor descriptor) {
        return new StorageBasedCacheManager(context, ownerClass, descriptor, new DefaultStorageFactory(descriptor));
    }

    public StorageFactory getStorageFactory(CacheContext context, CacheDescriptor descriptor, Class<? extends StorageFactory> storageFactory) {
        if (storageFactory != DefaultStorageFactory.class) {
            if (StorageFactory.class.isAssignableFrom(storageFactory)) {
                Constructor<? extends StorageFactory> ctor = CustomStorageFactory.getCustomConstructor(storageFactory);
                if (ctor != null) {
                    Object[] arguments = CustomStorageFactory.createArguments(ctor, context, descriptor);
                    try {
                        return ctor.newInstance(arguments);
                    }
                    catch (Exception e) {
                        logger.error(String.format(CANNOT_INSTANTIATE_MESSAGE, descriptor, storageFactory), (Throwable)e);
                    }
                } else {
                    logger.error(String.format(CANNOT_INSTANTIATE_MESSAGE, descriptor, storageFactory));
                }
            } else {
                logger.error("Invalid cache manager for " + descriptor + " (" + storageFactory + " is not StorageFactory)");
            }
        }
        return new DefaultStorageFactory(descriptor);
    }
}

