/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.interfaces.Statistics;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nonnull;

public class MutableStatisticsImpl
implements MutableStatistics {
    private static final AtomicIntegerFieldUpdater<MutableStatisticsImpl> HITS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(MutableStatisticsImpl.class, "hits");
    private static final AtomicIntegerFieldUpdater<MutableStatisticsImpl> MISSES_UPDATER = AtomicIntegerFieldUpdater.newUpdater(MutableStatisticsImpl.class, "misses");
    private static final AtomicLongFieldUpdater<MutableStatisticsImpl> TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(MutableStatisticsImpl.class, "time");
    private volatile long time;
    private volatile int hits;
    private volatile int misses;

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public int getMisses() {
        return this.misses;
    }

    @Override
    public double getAverageCalculationTime() {
        return (double)this.time / (double)this.misses;
    }

    @Override
    public long getTotalCalculationTime() {
        return this.time;
    }

    @Override
    public void reset() {
        HITS_UPDATER.set(this, 0);
        MISSES_UPDATER.set(this, 0);
        TIME_UPDATER.set(this, 0L);
    }

    @Override
    public void hit() {
        HITS_UPDATER.incrementAndGet(this);
    }

    @Override
    public synchronized void miss(long time) {
        MISSES_UPDATER.incrementAndGet(this);
        TIME_UPDATER.addAndGet(this, time);
    }

    public String toString() {
        return "Statistics{hits = " + this.hits + ", misses = " + this.misses + ", avg calculation = " + this.getAverageCalculationTime() + "}";
    }

    @Override
    @Nonnull
    public Statistics getStatistics() {
        return this;
    }
}

