/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.impl.StorageBasedCacheManager;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.interfaces.Statistics;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.proxy.ProxyFactory;
import com.maxifier.mxcache.proxy.Resolvable;
import com.maxifier.mxcache.proxy.ResolvableGenerator;
import com.maxifier.mxcache.transform.TransformGenerator;
import com.maxifier.mxcache.util.ClassGenerator;
import com.maxifier.mxcache.util.CodegenHelper;
import com.maxifier.mxcache.util.MxConstructorGenerator;
import com.maxifier.mxcache.util.MxField;
import com.maxifier.mxcache.util.MxGeneratorAdapter;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;

public final class ProxyingCacheGenerator {
    private static final Type STATISTICS_TYPE = Type.getType(Statistics.class);
    private static final Type PROXY_FACTORY_TYPE = Type.getType(ProxyFactory.class);
    private static final Type RESOLVABLE_TYPE = Type.getType(Resolvable.class);
    private static final Type LOCK_TYPE = Type.getType(Lock.class);
    private static final Type DEPENDENCY_NODE_TYPE = Type.getType(DependencyNode.class);
    private static final String CACHE_FIELD = "cache";
    private static final String PROXY_FACTORY_FIELD = "proxyFactory";
    private static final String DUMMY_NODE_FIELD_NAME = "DUMMY_NODE";
    private static final Method GET_STATISTICS_METHOD = new Method("getStatistics", STATISTICS_TYPE, CodegenHelper.EMPTY_TYPES);
    private static final Method SIZE_METHOD = new Method("getSize", Type.INT_TYPE, CodegenHelper.EMPTY_TYPES);
    private static final Method OWNER_METHOD = new Method("getCacheOwner", CodegenHelper.OBJECT_TYPE, CodegenHelper.EMPTY_TYPES);
    private static final Method GET_LOCK_METHOD = new Method("getLock", LOCK_TYPE, CodegenHelper.EMPTY_TYPES);
    private static final Method INVALIDATE_METHOD = Method.getMethod((String)"void invalidate()");
    private static final Method PROXY_METHOD = new Method("proxy", CodegenHelper.OBJECT_TYPE, new Type[]{CodegenHelper.CLASS_TYPE, RESOLVABLE_TYPE});
    private static final String GET_OR_CREATE = "getOrCreate";
    private static final AtomicInteger PROXYING_CALCULATABLE_ID = new AtomicInteger();

    private ProxyingCacheGenerator() {
    }

    public static Cache wrapCacheWithProxy(CacheDescriptor descriptor, CacheContext context, Cache cache) {
        ProxyFactory proxyFactory = descriptor.getProxyFactory(context);
        Class key = descriptor.getKeyType();
        Class value = descriptor.getValueType();
        Class<? extends Cache> cacheInterface = descriptor.getCacheInterface();
        TransformGenerator keyTransform = descriptor.getKeyTransform();
        ClassLoader owner = descriptor.getDeclaringClass().getClassLoader();
        return ProxyingCacheGenerator.wrapCacheWithProxy(owner, cache, proxyFactory, key, value, cacheInterface, keyTransform);
    }

    public static Cache wrapCacheWithProxy(ClassLoader owner, Cache cache, ProxyFactory proxyFactory, Class key, Class value, Class<?> cacheInterface, TransformGenerator keyTransform) {
        if (proxyFactory == null) {
            return cache;
        }
        Class calculatableClass = ProxyingCacheGenerator.generateProxyingCacheClass(owner, key, value, cacheInterface, keyTransform);
        try {
            return (Cache)calculatableClass.getConstructors()[0].newInstance(cache, proxyFactory);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Invalid calculatable generated", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Invalid calculatable generated", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Invalid calculatable generated", e);
        }
    }

    private static byte[] generateProxyingCacheBytecode(ClassLoader owner, Class key, Class value, Class cacheInterface, TransformGenerator keyTransform) {
        TransformGenerator[] transformGeneratorArray;
        Type[] typeArray;
        Type[] typeArray2;
        if (value.isPrimitive()) {
            throw new UnsupportedOperationException("Cannot proxy primitive!");
        }
        Type ekey = key == null ? null : CodegenHelper.erase(Type.getType((Class)key));
        int id = PROXYING_CALCULATABLE_ID.getAndIncrement();
        String packageName = StorageBasedCacheManager.class.getPackage().getName().replace('.', '/');
        String thisName = packageName + "/ProxyingCache$" + id;
        String calculatableName = packageName + "/ProxyingCache$" + id + "$Calculatable";
        Type calculatableType = Type.getObjectType((String)calculatableName);
        Type cacheType = Type.getType((Class)cacheInterface);
        ClassGenerator writer = new ClassGenerator(4129, thisName, CodegenHelper.OBJECT_TYPE, cacheType);
        MxField cacheField = writer.defineField(18, CACHE_FIELD, cacheType);
        MxField proxyFactoryField = writer.defineField(18, PROXY_FACTORY_FIELD, PROXY_FACTORY_TYPE);
        ProxyingCacheGenerator.generateGetDependencyNode(writer);
        ProxyingCacheGenerator.generateSize(writer, cacheField);
        ProxyingCacheGenerator.generateOwner(writer, cacheField);
        ProxyingCacheGenerator.generateGetStatistics(writer, cacheField);
        ProxyingCacheGenerator.generateCtor(writer, cacheField, proxyFactoryField);
        ProxyingCacheGenerator.generateGetOrCreate(key, value, writer, calculatableType, ekey, cacheField, proxyFactoryField);
        ProxyingCacheGenerator.generateGetLock(writer, cacheField);
        ProxyingCacheGenerator.generateInvalidate(writer, cacheField);
        writer.visitEnd();
        if (key == null) {
            typeArray2 = CodegenHelper.EMPTY_TYPES;
        } else {
            Type[] typeArray3 = new Type[1];
            typeArray2 = typeArray3;
            typeArray3[0] = Type.getType((Class)key);
        }
        Type[] keyTypes = typeArray2;
        if (ekey == null) {
            typeArray = CodegenHelper.EMPTY_TYPES;
        } else {
            Type[] typeArray4 = new Type[1];
            typeArray = typeArray4;
            typeArray4[0] = ekey;
        }
        Type[] ekeyTypes = typeArray;
        if (keyTransform == null) {
            transformGeneratorArray = null;
        } else {
            TransformGenerator[] transformGeneratorArray2 = new TransformGenerator[1];
            transformGeneratorArray = transformGeneratorArray2;
            transformGeneratorArray2[0] = keyTransform;
        }
        TransformGenerator[] transforms = transformGeneratorArray;
        ResolvableGenerator.generateResolvable(owner, calculatableName, cacheInterface, new Method(GET_OR_CREATE, CodegenHelper.OBJECT_TYPE, ekeyTypes), keyTypes, false, transforms);
        return writer.toByteArray();
    }

    private static void generateGetDependencyNode(ClassGenerator writer) {
        MxGeneratorAdapter getDependencyNode = writer.defineMethod(1, "getDependencyNode", DEPENDENCY_NODE_TYPE, new Type[0]);
        getDependencyNode.visitCode();
        getDependencyNode.getStatic(Type.getType(DependencyTracker.class), DUMMY_NODE_FIELD_NAME, DEPENDENCY_NODE_TYPE);
        getDependencyNode.returnValue();
        getDependencyNode.endMethod();
    }

    private static void generateSize(ClassGenerator writer, MxField cacheField) {
        MxGeneratorAdapter size = writer.defineMethod(1, SIZE_METHOD);
        size.visitCode();
        size.get(cacheField);
        size.invokeInterface(cacheField.getType(), SIZE_METHOD);
        size.returnValue();
        size.endMethod();
    }

    private static void generateOwner(ClassGenerator writer, MxField cacheField) {
        MxGeneratorAdapter size = writer.defineMethod(1, OWNER_METHOD);
        size.visitCode();
        size.get(cacheField);
        size.invokeInterface(cacheField.getType(), OWNER_METHOD);
        size.returnValue();
        size.endMethod();
    }

    private static void generateGetStatistics(ClassGenerator writer, MxField cacheField) {
        MxGeneratorAdapter size = writer.defineMethod(1, GET_STATISTICS_METHOD);
        size.visitCode();
        size.get(cacheField);
        size.invokeInterface(cacheField.getType(), GET_STATISTICS_METHOD);
        size.returnValue();
        size.endMethod();
    }

    private static Class generateProxyingCacheClass(ClassLoader owner, Class key, Class value, Class cacheInterface, TransformGenerator keyTransform) {
        byte[] bytecode = ProxyingCacheGenerator.generateProxyingCacheBytecode(owner, key, value, cacheInterface, keyTransform);
        return CodegenHelper.loadClass(owner, bytecode);
    }

    private static void generateInvalidate(ClassGenerator writer, MxField cacheField) {
        MxGeneratorAdapter clear = writer.defineMethod(1, INVALIDATE_METHOD);
        clear.visitCode();
        clear.get(cacheField);
        clear.invokeInterface(cacheField.getType(), INVALIDATE_METHOD);
        clear.returnValue();
        clear.endMethod();
    }

    private static void generateGetLock(ClassGenerator writer, MxField cacheField) {
        MxGeneratorAdapter getLock = writer.defineMethod(1, GET_LOCK_METHOD);
        getLock.visitCode();
        getLock.get(cacheField);
        getLock.invokeInterface(cacheField.getType(), GET_LOCK_METHOD);
        getLock.returnValue();
        getLock.endMethod();
    }

    private static void generateCtor(ClassGenerator writer, MxField cacheField, MxField proxyFactoryField) {
        MxConstructorGenerator ctor = writer.defineConstructor(1, cacheField.getType(), proxyFactoryField.getType());
        ctor.callSuper();
        ctor.initFields(cacheField, proxyFactoryField);
        ctor.returnValue();
        ctor.endMethod();
    }

    private static void generateGetOrCreate(Class key, Class value, ClassGenerator writer, Type calculatableType, Type ekey, MxField cacheField, MxField proxyFactoryField) {
        Type[] typeArray;
        Type[] typeArray2;
        if (ekey == null) {
            typeArray2 = CodegenHelper.EMPTY_TYPES;
        } else {
            Type[] typeArray3 = new Type[1];
            typeArray2 = typeArray3;
            typeArray3[0] = ekey;
        }
        MxGeneratorAdapter calculate = writer.defineMethod(1, GET_OR_CREATE, CodegenHelper.OBJECT_TYPE, typeArray2);
        calculate.visitCode();
        calculate.get(proxyFactoryField);
        calculate.push(Type.getType((Class)value));
        calculate.newInstance(calculatableType);
        calculate.dup();
        calculate.get(cacheField);
        if (key != null) {
            calculate.loadArg(0);
            if (!key.isPrimitive()) {
                calculate.checkCast(Type.getType((Class)key));
            }
        }
        if (ekey == null) {
            Type[] typeArray4 = new Type[1];
            typeArray = typeArray4;
            typeArray4[0] = cacheField.getType();
        } else {
            Type[] typeArray5 = new Type[2];
            typeArray5[0] = cacheField.getType();
            typeArray = typeArray5;
            typeArray5[1] = ekey;
        }
        calculate.invokeConstructor(calculatableType, new Method("<init>", Type.VOID_TYPE, typeArray));
        calculate.invokeInterface(PROXY_FACTORY_TYPE, PROXY_METHOD);
        calculate.returnValue();
        calculate.endMethod();
    }
}

