/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.impl.RegistryEntry;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.CacheManager;
import gnu.trove.map.hash.THashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class RegistryCatalogue {
    private final CacheDescriptor descriptor;
    private final Map<Class<?>, RegistryEntry> byOwnerClass = new THashMap();

    RegistryCatalogue(CacheDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Nonnull
    CacheDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Nonnull
    RegistryEntry forClass(Class<?> ownerClass) {
        RegistryEntry entry = this.byOwnerClass.get(ownerClass);
        if (entry == null) {
            entry = new RegistryEntry(ownerClass, this.descriptor);
            this.byOwnerClass.put(ownerClass, entry);
        }
        return entry;
    }

    void addManagers(List<CacheManager> res) {
        for (RegistryEntry registryEntry : this.byOwnerClass.values()) {
            res.addAll(registryEntry.getManagers());
        }
    }
}

