/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs;

import com.maxifier.mxcache.LightweightLock;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.interfaces.Statistics;
import com.maxifier.mxcache.storage.Storage;
import javax.annotation.Nullable;

public abstract class AbstractCache
extends LightweightLock
implements Cache,
Storage {
    private final MutableStatistics statistics;
    protected final Object owner;
    private DependencyNode node;
    private volatile boolean dirty;

    protected AbstractCache(Object owner, @Nullable MutableStatistics statistics) {
        this.owner = owner;
        this.statistics = statistics;
    }

    @Override
    public void setDependencyNode(DependencyNode node) {
        this.node = node;
    }

    @Override
    public DependencyNode getDependencyNode() {
        return this.node;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void invalidate() {
        this.dirty = true;
        if (this.tryLock()) {
            try {
                if (this.dirty) {
                    this.clear();
                    this.dirty = false;
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    protected void postCheckDirty() {
        if (this.dirty && this.tryLock()) {
            try {
                if (this.dirty) {
                    this.clear();
                    this.dirty = false;
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    protected void preCheckDirty() {
        if (this.dirty) {
            this.lock();
            try {
                if (this.dirty) {
                    this.clear();
                    this.dirty = false;
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    protected final void miss(long dt) {
        if (this.statistics != null) {
            this.statistics.miss(dt);
        }
    }

    protected final void hit() {
        if (this.statistics != null) {
            this.statistics.hit();
        }
    }

    @Override
    public int getSize() {
        this.lock();
        try {
            int n = this.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }
}

