/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.IntFloatCache;
import com.maxifier.mxcache.caches.IntFloatCalculatable;
import com.maxifier.mxcache.exceptions.CacheExceptionHandler;
import com.maxifier.mxcache.exceptions.ExceptionHelper;
import com.maxifier.mxcache.exceptions.ExceptionRecord;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.AbstractCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.IntObjectStorage;

public abstract class AbstractIntFloatCache
extends AbstractCache
implements IntFloatCache,
IntObjectStorage {
    private final IntFloatCalculatable calculatable;

    public AbstractIntFloatCache(Object owner, IntFloatCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public float getOrCreate(int o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.preCheckDirty();
        this.lock();
        try {
            Object v = this.load(o);
            if (v != UNDEFINED) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                ExceptionHelper.throwIfExceptionRecordNotExpired(v);
                float f = ((Float)v).floatValue();
                return f;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                float f;
                try {
                    f = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock();
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock();
                        }
                        v = this.load(o);
                        if (v == UNDEFINED) break block19;
                        this.hit();
                        ExceptionHelper.throwIfExceptionRecordNotExpired(v);
                        float f2 = ((Float)v).floatValue();
                        DependencyTracker.exit(callerNode);
                        this.unlock();
                        this.postCheckDirty();
                        return f2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return f;
                break;
            }
        }
        finally {
            this.unlock();
            this.postCheckDirty();
        }
    }

    protected float create(int o) {
        long start = System.nanoTime();
        try {
            int retry = 0;
            block10: while (true) {
                try {
                    float t = this.calculatable.calculate(this.owner, o);
                    this.save(o, Float.valueOf(t));
                    float f = t;
                    return f;
                }
                catch (Exception e) {
                    CacheExceptionHandler exceptionHandler = this.getDescriptor().getExceptionHandler();
                    switch (exceptionHandler.getAction(retry, e)) {
                        case RETRY: {
                            ++retry;
                            continue block10;
                        }
                        case REMEMBER_AND_RETHROW: {
                            this.save(o, new ExceptionRecord(e, exceptionHandler.getRememberExceptionExpirationTimestamp(e)));
                        }
                    }
                    ExceptionHelper.throwCheckedExceptionHack(e);
                    continue;
                }
                break;
            }
        }
        finally {
            long end = System.nanoTime();
            this.miss(end - start);
        }
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    @Override
    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

