/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.ObjectCharacterCache;
import com.maxifier.mxcache.caches.ObjectCharacterCalculatable;
import com.maxifier.mxcache.exceptions.CacheExceptionHandler;
import com.maxifier.mxcache.exceptions.ExceptionHelper;
import com.maxifier.mxcache.exceptions.ExceptionRecord;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.AbstractCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.ObjectObjectStorage;

public abstract class AbstractObjectCharacterCache<E>
extends AbstractCache
implements ObjectCharacterCache<E>,
ObjectObjectStorage<E> {
    private final ObjectCharacterCalculatable<E> calculatable;

    public AbstractObjectCharacterCache(Object owner, ObjectCharacterCalculatable<E> calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public char getOrCreate(E o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.preCheckDirty();
        this.lock();
        try {
            Object v = this.load(o);
            if (v != UNDEFINED) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                ExceptionHelper.throwIfExceptionRecordNotExpired(v);
                char c = ((Character)v).charValue();
                return c;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                char c;
                try {
                    c = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock();
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock();
                        }
                        v = this.load(o);
                        if (v == UNDEFINED) break block19;
                        this.hit();
                        ExceptionHelper.throwIfExceptionRecordNotExpired(v);
                        char c2 = ((Character)v).charValue();
                        DependencyTracker.exit(callerNode);
                        this.unlock();
                        this.postCheckDirty();
                        return c2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return c;
                break;
            }
        }
        finally {
            this.unlock();
            this.postCheckDirty();
        }
    }

    protected char create(E o) {
        long start = System.nanoTime();
        try {
            int retry = 0;
            block10: while (true) {
                try {
                    char t = this.calculatable.calculate(this.owner, o);
                    this.save(o, Character.valueOf(t));
                    char c = t;
                    return c;
                }
                catch (Exception e) {
                    CacheExceptionHandler exceptionHandler = this.getDescriptor().getExceptionHandler();
                    switch (exceptionHandler.getAction(retry, e)) {
                        case RETRY: {
                            ++retry;
                            continue block10;
                        }
                        case REMEMBER_AND_RETHROW: {
                            this.save(o, new ExceptionRecord(e, exceptionHandler.getRememberExceptionExpirationTimestamp(e)));
                        }
                    }
                    ExceptionHelper.throwCheckedExceptionHack(e);
                    continue;
                }
                break;
            }
        }
        finally {
            long end = System.nanoTime();
            this.miss(end - start);
        }
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    @Override
    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

