/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs.elementlocked;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.BooleanDoubleCache;
import com.maxifier.mxcache.caches.BooleanDoubleCalculatable;
import com.maxifier.mxcache.exceptions.CacheExceptionHandler;
import com.maxifier.mxcache.exceptions.ExceptionHelper;
import com.maxifier.mxcache.exceptions.ExceptionRecord;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.elementlocked.AbstractElementLockedCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.elementlocked.BooleanObjectElementLockedStorage;

public abstract class AbstractBooleanDoubleCache
extends AbstractElementLockedCache
implements BooleanDoubleCache,
BooleanObjectElementLockedStorage {
    private final BooleanDoubleCalculatable calculatable;

    public AbstractBooleanDoubleCache(Object owner, BooleanDoubleCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public double getOrCreate(boolean o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.preCheckDirty();
        this.lock(o);
        try {
            Object v = this.load(o);
            ExceptionHelper.throwIfExceptionRecordNotExpired(v);
            if (v != UNDEFINED) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                double d = (Double)v;
                return d;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                double d;
                try {
                    d = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock(o);
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock(o);
                        }
                        v = this.load(o);
                        ExceptionHelper.throwIfExceptionRecordNotExpired(v);
                        if (v == UNDEFINED) break block19;
                        this.hit();
                        double d2 = (Double)v;
                        DependencyTracker.exit(callerNode);
                        this.unlock(o);
                        this.postCheckDirty();
                        return d2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return d;
                break;
            }
        }
        finally {
            this.unlock(o);
            this.postCheckDirty();
        }
    }

    protected double create(boolean o) {
        long start = System.nanoTime();
        try {
            int retry = 0;
            block10: while (true) {
                try {
                    double t = this.calculatable.calculate(this.owner, o);
                    this.save(o, t);
                    double d = t;
                    return d;
                }
                catch (Exception e) {
                    CacheExceptionHandler exceptionHandler = this.getDescriptor().getExceptionHandler();
                    switch (exceptionHandler.getAction(retry, e)) {
                        case RETRY: {
                            ++retry;
                            continue block10;
                        }
                        case REMEMBER_AND_RETHROW: {
                            this.save(o, new ExceptionRecord(e, exceptionHandler.getRememberExceptionExpirationTimestamp(e)));
                        }
                    }
                    ExceptionHelper.throwCheckedExceptionHack(e);
                    continue;
                }
                break;
            }
        }
        finally {
            long end = System.nanoTime();
            this.miss(end - start);
        }
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

