/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs.elementlocked;

import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.interfaces.Statistics;
import com.maxifier.mxcache.storage.elementlocked.ElementLockedStorage;
import java.util.concurrent.locks.Lock;

abstract class AbstractElementLockedCache
implements Cache,
ElementLockedStorage {
    protected final Object owner;
    private final MutableStatistics statistics;
    private DependencyNode node;
    private boolean dirty;

    protected AbstractElementLockedCache(Object owner, MutableStatistics statistics) {
        this.owner = owner;
        this.statistics = statistics;
    }

    @Override
    public void setDependencyNode(DependencyNode node) {
        this.node = node;
    }

    protected void miss(long dt) {
        this.statistics.miss(dt);
    }

    protected void hit() {
        this.statistics.hit();
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void invalidate() {
        Lock lock = this.getLock();
        this.dirty = true;
        if (lock.tryLock()) {
            try {
                if (this.dirty) {
                    this.clear();
                    this.dirty = false;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected void postCheckDirty() {
        Lock lock;
        if (this.dirty && (lock = this.getLock()).tryLock()) {
            try {
                if (this.dirty) {
                    this.clear();
                    this.dirty = false;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected void preCheckDirty() {
        if (this.dirty) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.dirty) {
                    this.clear();
                    this.dirty = false;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public int getSize() {
        Lock lock = this.getLock();
        lock.lock();
        try {
            int n = this.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public DependencyNode getDependencyNode() {
        return this.node;
    }
}

