/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs.elementlocked;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.FloatCache;
import com.maxifier.mxcache.caches.FloatCalculatable;
import com.maxifier.mxcache.exceptions.CacheExceptionHandler;
import com.maxifier.mxcache.exceptions.ExceptionHelper;
import com.maxifier.mxcache.exceptions.ExceptionRecord;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.elementlocked.AbstractElementLockedCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.elementlocked.ObjectElementLockedStorage;
import java.util.concurrent.locks.Lock;

public abstract class AbstractFloatCache
extends AbstractElementLockedCache
implements FloatCache,
ObjectElementLockedStorage {
    private final FloatCalculatable calculatable;

    public AbstractFloatCache(Object owner, FloatCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public float getOrCreate() {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner);
        }
        this.preCheckDirty();
        Lock lock = this.getLock();
        if (lock != null) {
            lock.lock();
        }
        try {
            Object v = this.load();
            ExceptionHelper.throwIfExceptionRecordNotExpired(v);
            if (v != UNDEFINED) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                float f = ((Float)v).floatValue();
                return f;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                float f;
                try {
                    f = this.create();
                }
                catch (ResourceOccupied e) {
                    block23: {
                        float f2;
                        block24: {
                            if (callerNode != null) {
                                throw e;
                            }
                            if (lock != null) {
                                lock.unlock();
                            }
                            try {
                                e.getResource().waitForEndOfModification();
                            }
                            finally {
                                if (lock != null) {
                                    lock.lock();
                                }
                            }
                            v = this.load();
                            ExceptionHelper.throwIfExceptionRecordNotExpired(v);
                            if (v == UNDEFINED) break block23;
                            this.hit();
                            f2 = ((Float)v).floatValue();
                            DependencyTracker.exit(callerNode);
                            if (lock == null) break block24;
                            lock.unlock();
                        }
                        this.postCheckDirty();
                        return f2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return f;
                break;
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
            this.postCheckDirty();
        }
    }

    protected float create() {
        long start = System.nanoTime();
        try {
            int retry = 0;
            block10: while (true) {
                try {
                    float t = this.calculatable.calculate(this.owner);
                    this.save(Float.valueOf(t));
                    float f = t;
                    return f;
                }
                catch (Exception e) {
                    CacheExceptionHandler exceptionHandler = this.getDescriptor().getExceptionHandler();
                    switch (exceptionHandler.getAction(retry, e)) {
                        case RETRY: {
                            ++retry;
                            continue block10;
                        }
                        case REMEMBER_AND_RETHROW: {
                            this.save(new ExceptionRecord(e, exceptionHandler.getRememberExceptionExpirationTimestamp(e)));
                        }
                    }
                    ExceptionHelper.throwCheckedExceptionHack(e);
                    continue;
                }
                break;
            }
        }
        finally {
            long end = System.nanoTime();
            this.miss(end - start);
        }
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

