/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs.elementlocked;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.ObjectIntCache;
import com.maxifier.mxcache.caches.ObjectIntCalculatable;
import com.maxifier.mxcache.exceptions.CacheExceptionHandler;
import com.maxifier.mxcache.exceptions.ExceptionHelper;
import com.maxifier.mxcache.exceptions.ExceptionRecord;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.elementlocked.AbstractElementLockedCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.elementlocked.ObjectObjectElementLockedStorage;

public abstract class AbstractObjectIntCache<E>
extends AbstractElementLockedCache
implements ObjectIntCache<E>,
ObjectObjectElementLockedStorage<E> {
    private final ObjectIntCalculatable<E> calculatable;

    public AbstractObjectIntCache(Object owner, ObjectIntCalculatable<E> calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int getOrCreate(E o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.preCheckDirty();
        this.lock(o);
        try {
            Object v = this.load(o);
            ExceptionHelper.throwIfExceptionRecordNotExpired(v);
            if (v != UNDEFINED) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                int n = (Integer)v;
                return n;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                int n;
                try {
                    n = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock(o);
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock(o);
                        }
                        v = this.load(o);
                        ExceptionHelper.throwIfExceptionRecordNotExpired(v);
                        if (v == UNDEFINED) break block19;
                        this.hit();
                        int n2 = (Integer)v;
                        DependencyTracker.exit(callerNode);
                        this.unlock(o);
                        this.postCheckDirty();
                        return n2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return n;
                break;
            }
        }
        finally {
            this.unlock(o);
            this.postCheckDirty();
        }
    }

    protected int create(E o) {
        long start = System.nanoTime();
        try {
            int retry = 0;
            block10: while (true) {
                try {
                    int t = this.calculatable.calculate(this.owner, o);
                    this.save(o, t);
                    int n = t;
                    return n;
                }
                catch (Exception e) {
                    CacheExceptionHandler exceptionHandler = this.getDescriptor().getExceptionHandler();
                    switch (exceptionHandler.getAction(retry, e)) {
                        case RETRY: {
                            ++retry;
                            continue block10;
                        }
                        case REMEMBER_AND_RETHROW: {
                            this.save(o, new ExceptionRecord(e, exceptionHandler.getRememberExceptionExpirationTimestamp(e)));
                        }
                    }
                    ExceptionHelper.throwCheckedExceptionHack(e);
                    continue;
                }
                break;
            }
        }
        finally {
            long end = System.nanoTime();
            this.miss(end - start);
        }
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

