/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs.elementlocked;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.ShortShortCache;
import com.maxifier.mxcache.caches.ShortShortCalculatable;
import com.maxifier.mxcache.exceptions.CacheExceptionHandler;
import com.maxifier.mxcache.exceptions.ExceptionHelper;
import com.maxifier.mxcache.exceptions.ExceptionRecord;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.elementlocked.AbstractElementLockedCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.elementlocked.ShortObjectElementLockedStorage;

public abstract class AbstractShortShortCache
extends AbstractElementLockedCache
implements ShortShortCache,
ShortObjectElementLockedStorage {
    private final ShortShortCalculatable calculatable;

    public AbstractShortShortCache(Object owner, ShortShortCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public short getOrCreate(short o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.preCheckDirty();
        this.lock(o);
        try {
            Object v = this.load(o);
            ExceptionHelper.throwIfExceptionRecordNotExpired(v);
            if (v != UNDEFINED) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                short s = (Short)v;
                return s;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                short s;
                try {
                    s = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock(o);
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock(o);
                        }
                        v = this.load(o);
                        ExceptionHelper.throwIfExceptionRecordNotExpired(v);
                        if (v == UNDEFINED) break block19;
                        this.hit();
                        short s2 = (Short)v;
                        DependencyTracker.exit(callerNode);
                        this.unlock(o);
                        this.postCheckDirty();
                        return s2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return s;
                break;
            }
        }
        finally {
            this.unlock(o);
            this.postCheckDirty();
        }
    }

    protected short create(short o) {
        long start = System.nanoTime();
        try {
            int retry = 0;
            block10: while (true) {
                try {
                    short t = this.calculatable.calculate(this.owner, o);
                    this.save(o, t);
                    short s = t;
                    return s;
                }
                catch (Exception e) {
                    CacheExceptionHandler exceptionHandler = this.getDescriptor().getExceptionHandler();
                    switch (exceptionHandler.getAction(retry, e)) {
                        case RETRY: {
                            ++retry;
                            continue block10;
                        }
                        case REMEMBER_AND_RETHROW: {
                            this.save(o, new ExceptionRecord(e, exceptionHandler.getRememberExceptionExpirationTimestamp(e)));
                        }
                    }
                    ExceptionHelper.throwCheckedExceptionHack(e);
                    continue;
                }
                break;
            }
        }
        finally {
            long end = System.nanoTime();
            this.miss(end - start);
        }
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

