/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.def;

import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.caches.ShortCalculatable;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.def.ShortInlineCacheImpl;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.util.HashWeakReference;
import gnu.trove.set.hash.THashSet;
import java.lang.ref.Reference;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;

public class ShortInlineDependencyCache
extends ShortInlineCacheImpl
implements DependencyNode {
    private Set<Reference<DependencyNode>> dependentNodes;
    private Reference<DependencyNode> selfReference;

    public ShortInlineDependencyCache(Object owner, ShortCalculatable calculable, MutableStatistics statistics) {
        super(owner, calculable, statistics);
        this.setDependencyNode(this);
    }

    @Override
    public synchronized void visitDependantNodes(DependencyNode.Visitor visitor) {
        if (this.dependentNodes != null) {
            Iterator<Reference<DependencyNode>> it = this.dependentNodes.iterator();
            while (it.hasNext()) {
                Reference<DependencyNode> ref = it.next();
                DependencyNode instance = ref.get();
                if (instance != null) {
                    visitor.visit(instance);
                    continue;
                }
                it.remove();
            }
        }
    }

    @Override
    public synchronized Reference<DependencyNode> getSelfReference() {
        if (this.selfReference == null) {
            this.selfReference = new HashWeakReference<ShortInlineDependencyCache>(this);
        }
        return this.selfReference;
    }

    @Override
    public synchronized void trackDependency(DependencyNode node) {
        if (this.dependentNodes == null) {
            this.dependentNodes = new THashSet();
        }
        this.dependentNodes.add(node.getSelfReference());
    }

    @Override
    public void addNode(@Nonnull CleaningNode cache) {
        throw new UnsupportedOperationException("Inline dependency node should has only one cache");
    }
}

