/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.instanceprovider;

import com.maxifier.mxcache.InstanceProvider;
import com.maxifier.mxcache.impl.instanceprovider.Binder;
import com.maxifier.mxcache.impl.instanceprovider.ConstProvider;
import com.maxifier.mxcache.impl.instanceprovider.DelegatingProvider;
import com.maxifier.mxcache.impl.instanceprovider.Provider;
import java.util.Map;
import javax.annotation.Nonnull;

class BinderImpl<T>
implements Binder<T> {
    private final Class<T> cls;
    private final InstanceProvider instanceProvider;
    private final Map<Class, Provider> registry;

    public BinderImpl(InstanceProvider instanceProvider, Map<Class, Provider> registry, Class<T> cls) {
        this.instanceProvider = instanceProvider;
        this.registry = registry;
        this.cls = cls;
    }

    @Override
    public void toProvider(@Nonnull Provider<T> provider) {
        this.registry.put(this.cls, provider);
    }

    @Override
    public void toInstance(@Nonnull T instance) {
        if (!this.cls.isInstance(instance)) {
            throw new IllegalArgumentException("Cannot bind " + this.cls + " to instance of " + instance.getClass());
        }
        this.registry.put(this.cls, new ConstProvider<T>(instance));
    }

    @Override
    public void toClass(@Nonnull Class<? extends T> cls) {
        if (cls == this.cls) {
            throw new IllegalArgumentException("Cannot bind " + this.cls + " to itself");
        }
        if (!this.cls.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Cannot bind " + this.cls + " to " + cls);
        }
        this.registry.put(this.cls, new DelegatingProvider<T>(this.instanceProvider, cls));
    }
}

