/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.resource;

import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.util.HashWeakReference;
import gnu.trove.set.hash.THashSet;
import java.lang.ref.Reference;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractDependencyNode
implements DependencyNode {
    private Set<Reference<DependencyNode>> dependentNodes;
    private Reference<DependencyNode> selfReference;

    @Override
    public synchronized void visitDependantNodes(DependencyNode.Visitor visitor) {
        if (this.dependentNodes != null) {
            Iterator<Reference<DependencyNode>> it = this.dependentNodes.iterator();
            while (it.hasNext()) {
                Reference<DependencyNode> ref = it.next();
                DependencyNode instance = ref.get();
                if (instance != null) {
                    visitor.visit(instance);
                    continue;
                }
                it.remove();
            }
        }
    }

    public synchronized int getApproxSize() {
        return this.dependentNodes == null ? 0 : this.dependentNodes.size();
    }

    @Override
    public synchronized Reference<DependencyNode> getSelfReference() {
        if (this.selfReference == null) {
            this.selfReference = new HashWeakReference<AbstractDependencyNode>(this);
        }
        return this.selfReference;
    }

    @Override
    public synchronized void trackDependency(DependencyNode node) {
        if (this.dependentNodes == null) {
            this.dependentNodes = new THashSet();
        }
        this.dependentNodes.add(node.getSelfReference());
    }

    protected static boolean equal(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }
}

